/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class RenderHelper {
    public static void drawTexture(PoseStack stack, ResourceLocation resource, double posX, double posY, double width, double height, double zLevel) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)resource);
        RenderHelper.draw(stack, posX, posY, width, height, zLevel);
    }

    public static void draw(PoseStack stack, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.draw(stack, posX, posY, width, height, zLevel, 0.0, 1.0, 0.0, 1.0);
    }

    public static void draw(PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix = stack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.vertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).uv((float)u1, (float)v2).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).uv((float)u2, (float)v2).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).uv((float)u2, (float)v1).endVertex();
        bufferbuilder.vertex(matrix, (float)posX, (float)posY, (float)zLevel).uv((float)u1, (float)v1).endVertex();
        tessellator.end();
    }

    public static void startDrawBatch() {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
    }

    public static void drawBatch(PoseStack stack, double posX, double posY, double width, double height, double zLevel, double u1, double u2, double v1, double v2) {
        Matrix4f matrix = stack.last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        bufferbuilder.vertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).uv((float)u1, (float)v2).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).uv((float)u2, (float)v2).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).uv((float)u2, (float)v1).endVertex();
        bufferbuilder.vertex(matrix, (float)posX, (float)posY, (float)zLevel).uv((float)u1, (float)v1).endVertex();
    }

    public static void endDrawBatch() {
        Tesselator.getInstance().end();
    }

    public static void drawColour(GuiGraphics graphics, int colour, int alpha, double posX, double posY, double width, double height, double zLevel) {
        int r = colour >> 16 & 0xFF;
        int g = colour >> 8 & 0xFF;
        int b = colour & 0xFF;
        RenderHelper.drawColour(graphics, r, g, b, alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(GuiGraphics graphics, int[] rgb, int alpha, double posX, double posY, double width, double height, double zLevel) {
        RenderHelper.drawColour(graphics, rgb[0], rgb[1], rgb[2], alpha, posX, posY, width, height, zLevel);
    }

    public static void drawColour(GuiGraphics graphics, int r, int g, int b, int alpha, double posX, double posY, double width, double height, double zLevel) {
        if (width <= 0.0 || height <= 0.0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        Matrix4f matrix = graphics.pose().last().pose();
        Tesselator tessellator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tessellator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.vertex(matrix, (float)posX, (float)(posY + height), (float)zLevel).color(r, g, b, alpha).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)(posY + height), (float)zLevel).color(r, g, b, alpha).endVertex();
        bufferbuilder.vertex(matrix, (float)(posX + width), (float)posY, (float)zLevel).color(r, g, b, alpha).endVertex();
        bufferbuilder.vertex(matrix, (float)posX, (float)posY, (float)zLevel).color(r, g, b, alpha).endVertex();
        tessellator.end();
    }

    public static void colour(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
    }

    public static void colour(int color, float alpha) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)alpha);
    }

    public static int getRandomColourFromString(String s) {
        Random rand = new Random();
        rand.setSeed(Math.abs(s.hashCode() * 1000));
        int clr = Math.round(1.6777215E7f * rand.nextFloat());
        float[] hsb = new float[3];
        Color.RGBtoHSB(clr >> 16 & 0xFF, clr >> 8 & 0xFF, clr & 0xFF, hsb);
        hsb[2] = 0.65f + 0.25f * hsb[2];
        clr = Color.HSBtoRGB(hsb[0], hsb[1], hsb[2]);
        return clr;
    }

    public static void startGlScissor(int x, int y, int width, int height) {
        Minecraft mc = Minecraft.getInstance();
        double scaleW = (double)mc.getWindow().getWidth() / (double)mc.getWindow().getGuiScaledWidth();
        double scaleH = (double)mc.getWindow().getHeight() / (double)mc.getWindow().getGuiScaledHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        RenderSystem.enableScissor((int)((int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.getWindow().getHeight() - (double)(y + height) * scaleH)), (int)((int)Math.floor((double)(x + width) * scaleW) - (int)Math.floor((double)x * scaleW)), (int)((int)Math.floor((double)mc.getWindow().getHeight() - (double)y * scaleH) - (int)Math.floor((double)mc.getWindow().getHeight() - (double)(y + height) * scaleH)));
    }

    public static void endGlScissor() {
        RenderSystem.disableScissor();
    }

    public static void renderTestScissor(GuiGraphics graphics) {
        Minecraft mc = Minecraft.getInstance();
        RenderHelper.startGlScissor(mc.getWindow().getGuiScaledWidth() / 2 - 50, mc.getWindow().getGuiScaledHeight() / 2 - 50, 100, 100);
        RenderHelper.drawColour(graphics, 0xFFFFFF, 255, 0.0, 0.0, (double)mc.getWindow().getGuiScaledWidth(), (double)mc.getWindow().getGuiScaledHeight(), 0.0);
        RenderHelper.endGlScissor();
    }
}

