/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.ichunutil.loader.neoforge;

import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.network.PacketChannel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

public class PacketChannelNeoForge
extends PacketChannel {
    public PacketChannelNeoForge(RegisterPayloadHandlerEvent event, ResourceLocation name, int protocolVersion, Class<? extends AbstractPacket> ... packetTypes) {
        this(event, name, protocolVersion, false, packetTypes);
    }

    public PacketChannelNeoForge(RegisterPayloadHandlerEvent event, ResourceLocation name, int protocolVersion, boolean isOptional, Class<? extends AbstractPacket> ... packetTypes) {
        super(name, packetTypes);
        IPayloadRegistrar registrar = event.registrar(this.channelId.getNamespace());
        registrar.versioned(Integer.toString(protocolVersion));
        if (isOptional) {
            registrar = registrar.optional();
        }
        registrar.play(this.channelId, x$0 -> this.readPacket((FriendlyByteBuf)x$0), this::handle);
    }

    protected void handle(PacketChannel.PacketPayload payload, IPayloadContext context) {
        Player player = null;
        if (context.flow() == PacketFlow.CLIENTBOUND) {
            player = this.getPlayer();
        } else if (context.player().isPresent()) {
            player = (Player)context.player().get();
        }
        payload.process(player).ifPresent(r -> context.workHandler().submitAsync(r));
    }

    @Override
    public void sendToServer(AbstractPacket packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{this.payload(packet)});
    }

    @Override
    public void sendTo(AbstractPacket packet, ServerPlayer player) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{this.payload(packet)});
    }

    @Override
    public void sendToAll(AbstractPacket packet) {
        PacketDistributor.ALL.noArg().send(new CustomPacketPayload[]{this.payload(packet)});
    }

    @Override
    public void sendToTracking(AbstractPacket packet, Entity entity) {
        PacketDistributor.TRACKING_ENTITY_AND_SELF.with((Object)entity).send(new CustomPacketPayload[]{this.payload(packet)});
    }

    @Override
    public void sendToAround(AbstractPacket packet, ServerLevel world, double x, double y, double z, double radius) {
        PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(x, y, z, radius, world.dimension())).send(new CustomPacketPayload[]{this.payload(packet)});
    }
}

