/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.util;

import com.mojang.logging.LogUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.mods.rhino.mod.util.neoforge.RhinoPropertiesImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;

public enum RhinoProperties {
    INSTANCE;

    private final Properties properties;
    private boolean writeProperties;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameDir() {
        return RhinoPropertiesImpl.getGameDir();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isDev() {
        return RhinoPropertiesImpl.isDev();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean needsRemapping() {
        return RhinoPropertiesImpl.needsRemapping();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static InputStream openResource(String path) throws Exception {
        return RhinoPropertiesImpl.openResource(path);
    }

    private RhinoProperties() {
        block16: {
            this.properties = new Properties();
            try {
                Path propertiesFile = RhinoProperties.getGameDir().resolve("rhino.local.properties");
                this.writeProperties = false;
                if (Files.exists(propertiesFile, new LinkOption[0])) {
                    try (BufferedReader reader = Files.newBufferedReader(propertiesFile);){
                        this.properties.load(reader);
                    }
                } else {
                    this.writeProperties = true;
                }
                if (!this.writeProperties) break block16;
                try (BufferedWriter writer = Files.newBufferedWriter(propertiesFile, new OpenOption[0]);){
                    this.properties.store(writer, "Local properties for Rhino, please do not push this to version control if you don't know what you're doing!");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        LogUtils.getLogger().info("Rhino properties loaded.");
    }

    private void remove(String key) {
        String s = this.properties.getProperty(key);
        if (s != null) {
            this.properties.remove(key);
            this.writeProperties = true;
        }
    }

    private String get(String key, String def) {
        String s = this.properties.getProperty(key);
        if (s == null) {
            this.properties.setProperty(key, def);
            this.writeProperties = true;
            return def;
        }
        return s;
    }

    private boolean get(String key, boolean def) {
        return this.get(key, def ? "true" : "false").equals("true");
    }
}

