/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Action;
import cpw.mods.inventorysorter.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public final class Network {
    private static final String PROTOCOL_VERSION = Integer.toString(1);

    public static void init(IEventBus bus) {
        bus.addListener(Network::registerEvent);
    }

    public static void registerEvent(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("inventorysorter").versioned(PROTOCOL_VERSION);
        registrar.play(ActionMessage.ID, ActionMessage::fromBytes, ServerHandler::onMessage);
    }

    public static class ActionMessage
    implements CustomPacketPayload {
        Action action;
        int slotIndex;
        public static ResourceLocation ID = new ResourceLocation("inventorysorter", "net");

        ActionMessage(Action action, int slotIndex) {
            this.action = action;
            this.slotIndex = slotIndex;
        }

        static ActionMessage fromBytes(FriendlyByteBuf buf) {
            return new ActionMessage(Action.values()[buf.readByte()], buf.readInt());
        }

        public void write(FriendlyByteBuf buf) {
            buf.writeByte(this.action.ordinal());
            buf.writeInt(this.slotIndex);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }
}

