/*
 * Decompiled with CFR 0.152.
 */
package fuzs.leavemybarsalone.neoforge.integration.appleskin;

import fuzs.leavemybarsalone.LeaveMyBarsAlone;
import fuzs.leavemybarsalone.neoforge.client.handler.NeoForgeRidingBarsHandler;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.gui.overlay.ExtendedGui;
import net.neoforged.neoforge.common.NeoForge;

public class AppleSkinIntegration {
    public static void init() {
        Object foodOverlayType;
        MethodHandle renderFoodOrHealthOverlayHandle;
        MethodHandle renderExhaustionHandle;
        try {
            Class<?> renderOverlayTypeClazz = Class.forName("squeek.appleskin.client.HUDOverlayHandler$RenderOverlayType");
            MethodType renderExhaustionType = MethodType.methodType(Void.TYPE, ExtendedGui.class, GuiGraphics.class, Float.TYPE, Integer.TYPE, Integer.TYPE);
            MethodType renderFoodOrHealthOverlayType = MethodType.methodType(Void.TYPE, ExtendedGui.class, GuiGraphics.class, Float.TYPE, Integer.TYPE, Integer.TYPE, renderOverlayTypeClazz);
            Class<?> clazz = Class.forName("squeek.appleskin.client.HUDOverlayHandler");
            renderExhaustionHandle = MethodHandles.publicLookup().findStatic(clazz, "renderExhaustion", renderExhaustionType);
            renderFoodOrHealthOverlayHandle = MethodHandles.publicLookup().findStatic(clazz, "renderFoodOrHealthOverlay", renderFoodOrHealthOverlayType);
            Field foodField = renderOverlayTypeClazz.getField("FOOD");
            foodField.setAccessible(true);
            MethodHandle foodGetter = MethodHandles.publicLookup().unreflectGetter(foodField);
            foodOverlayType = foodGetter.invoke();
        }
        catch (Throwable e) {
            LeaveMyBarsAlone.LOGGER.warn("Failed to initialize Apple Skin integration", e);
            return;
        }
        NeoForge.EVENT_BUS.addListener(evt -> AppleSkinIntegration.onRenderGuiOverlay$Pre(evt, renderExhaustionHandle));
        NeoForge.EVENT_BUS.addListener(evt -> AppleSkinIntegration.onRenderGuiOverlay$Post(evt, renderFoodOrHealthOverlayHandle, foodOverlayType));
    }

    private static void onRenderGuiOverlay$Pre(RenderGuiOverlayEvent.Pre evt, MethodHandle methodHandle) {
        if (evt.getOverlay().overlay() == NeoForgeRidingBarsHandler.FOOD_LEVEL_MOUNTED_GUI_OVERLAY) {
            Minecraft minecraft = Minecraft.getInstance();
            ExtendedGui gui = (ExtendedGui)minecraft.gui;
            if (minecraft.player.getVehicle() instanceof LivingEntity && !minecraft.options.hideGui && gui.shouldDrawSurvivalElements()) {
                try {
                    methodHandle.invoke(gui, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().getScreenWidth(), evt.getWindow().getScreenHeight());
                }
                catch (Throwable e) {
                    LeaveMyBarsAlone.LOGGER.warn("Failed to render Apple Skin exhaustion overlay", e);
                }
            }
        }
    }

    private static void onRenderGuiOverlay$Post(RenderGuiOverlayEvent.Post evt, MethodHandle methodHandle, Object foodOverlayType) {
        if (evt.getOverlay().overlay() == NeoForgeRidingBarsHandler.EXPERIENCE_BAR_MOUNTED_GUI_OVERLAY) {
            Minecraft minecraft = Minecraft.getInstance();
            ExtendedGui gui = (ExtendedGui)minecraft.gui;
            if (minecraft.player.getVehicle() instanceof LivingEntity && !minecraft.options.hideGui && gui.shouldDrawSurvivalElements()) {
                try {
                    methodHandle.invoke(gui, evt.getGuiGraphics(), evt.getPartialTick(), evt.getWindow().getScreenWidth(), evt.getWindow().getScreenHeight(), foodOverlayType);
                }
                catch (Throwable e) {
                    LeaveMyBarsAlone.LOGGER.warn("Failed to render Apple Skin food overlay", e);
                }
            }
        }
    }
}

