/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.client;

import com.mrbysco.nbt.command.BubbleText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BubbleHandler {
    private static final Map<String, List<BubbleText>> bubbleMap = new HashMap<String, List<BubbleText>>();
    private static final Map<UUID, List<BubbleText>> playerBubbleMap = new HashMap<UUID, List<BubbleText>>();
    public static final Map<UUID, String> uuidLookupCache = new HashMap<UUID, String>();

    public static boolean addBubble(String author, BubbleText bubbleText) {
        if (bubbleText == null) {
            return false;
        }
        List bubbleList = bubbleMap.getOrDefault(author, new ArrayList());
        if (bubbleList.contains(bubbleText)) {
            return false;
        }
        BubbleHandler.updateCache(bubbleText.uuid(), author);
        bubbleList.add(bubbleText);
        bubbleMap.put(author, bubbleList);
        return true;
    }

    public static boolean removeBubble(BubbleText bubbleText) {
        if (bubbleText == null) {
            return false;
        }
        String author = bubbleText.author();
        List bubbleList = bubbleMap.getOrDefault(author, new ArrayList());
        if (!bubbleList.contains(bubbleText)) {
            return false;
        }
        bubbleList.remove(bubbleText);
        if (bubbleMap.isEmpty()) {
            bubbleMap.remove(author);
        } else {
            bubbleMap.put(author, bubbleList);
        }
        return true;
    }

    public static List<BubbleText> getBubbles(String author) {
        return bubbleMap.getOrDefault(author, new ArrayList());
    }

    public static boolean addPlayerBubble(UUID uuid, BubbleText bubbleText) {
        if (bubbleText == null) {
            return false;
        }
        List bubbleList = playerBubbleMap.getOrDefault(uuid, new ArrayList());
        if (bubbleList.contains(bubbleText)) {
            return false;
        }
        bubbleList.add(bubbleText);
        playerBubbleMap.put(uuid, bubbleList);
        return true;
    }

    public static boolean removePlayerBubble(BubbleText bubbleText) {
        if (bubbleText == null) {
            return false;
        }
        UUID author = bubbleText.uuid();
        List bubbleList = playerBubbleMap.getOrDefault(author, new ArrayList());
        if (!bubbleList.contains(bubbleText)) {
            return false;
        }
        bubbleList.remove(bubbleText);
        if (bubbleList.isEmpty()) {
            playerBubbleMap.remove(author);
        } else {
            playerBubbleMap.put(author, bubbleList);
        }
        return true;
    }

    public static List<BubbleText> getPlayerBubbles(UUID author) {
        return playerBubbleMap.getOrDefault(author, new ArrayList());
    }

    public static String getAuthor(UUID uuid) {
        return uuidLookupCache.computeIfAbsent(uuid, value -> {
            for (Map.Entry<String, List<BubbleText>> entry : bubbleMap.entrySet()) {
                for (BubbleText bubble : entry.getValue()) {
                    if (bubble.uuid() != value) continue;
                    return entry.getKey();
                }
            }
            return "";
        });
    }

    public static void updateCache(UUID uuid, String author) {
        uuidLookupCache.put(uuid, author);
    }
}

