/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.nbt.NotableBubbleText;
import com.mrbysco.nbt.client.BubbleHandler;
import com.mrbysco.nbt.client.ConfigCache;
import com.mrbysco.nbt.client.util.BubbleRenderer;
import com.mrbysco.nbt.command.BubbleText;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientChatReceivedEvent;
import net.neoforged.neoforge.client.event.RenderLivingEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;

public class ClientHandler {
    @SubscribeEvent
    public <T extends LivingEntity> void onEntityRender(RenderLivingEvent.Post<T, ? extends EntityModel<T>> event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity.isInvisibleTo((Player)localPlayer)) {
            return;
        }
        String author = BubbleHandler.getAuthor(livingEntity.getUUID());
        if (!author.isEmpty()) {
            List<BubbleText> bubbles = BubbleHandler.getBubbles(author);
            if (bubbles.isEmpty()) {
                return;
            }
            BubbleText bubble = bubbles.get(0);
            ClientLevel level = mc.level;
            if (level == null) {
                return;
            }
            long currentTime = level.getGameTime();
            long bubbleTime = bubbles.size() > 1 ? 50L : 200L;
            long bubbleAge = bubble.getAge(currentTime);
            float bubbleAlpha = bubble.getAlpha(currentTime);
            Font font = mc.font;
            PoseStack poseStack = event.getPoseStack();
            EntityDimensions dimensions = livingEntity.getDimensions(livingEntity.getPose());
            MultiBufferSource multiBufferSource = event.getMultiBufferSource();
            EntityRenderDispatcher renderDispatcher = mc.getEntityRenderDispatcher();
            double nameOffset = ClientHandler.getNameOffset(renderDispatcher, livingEntity);
            BubbleRenderer.renderBubbleText(bubble, poseStack, font, multiBufferSource, renderDispatcher, dimensions.height, bubbleAlpha, event.getPackedLight(), nameOffset);
            if (bubbleAge > bubbleTime) {
                BubbleHandler.removeBubble(bubble);
            }
        }
    }

    public static double getNameOffset(EntityRenderDispatcher renderDispatcher, LivingEntity livingEntity) {
        boolean flag;
        double nameOffset = 0.0;
        if (!ConfigCache.nameOffset) {
            return nameOffset;
        }
        boolean bl = flag = livingEntity.shouldShowName() || livingEntity == renderDispatcher.crosshairPickEntity && livingEntity.hasCustomName();
        if (flag) {
            nameOffset += (double)livingEntity.getNameTagOffsetY() * 0.3125;
        }
        return nameOffset;
    }

    @SubscribeEvent
    public void onPlayerRender(RenderPlayerEvent.Post event) {
        if (!ConfigCache.renderPlayerBubbles) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        Player player = event.getEntity();
        if (player.isInvisibleTo((Player)localPlayer)) {
            return;
        }
        List<BubbleText> bubbles = BubbleHandler.getPlayerBubbles(player.getUUID());
        if (!bubbles.isEmpty()) {
            BubbleText bubble = bubbles.get(0);
            ClientLevel level = mc.level;
            if (level == null) {
                return;
            }
            long currentTime = level.getGameTime();
            long bubbleTime = bubbles.size() > 1 ? 50L : 200L;
            long bubbleAge = bubble.getAge(currentTime);
            float bubbleAlpha = bubble.getAlpha(currentTime);
            Font font = mc.font;
            PoseStack poseStack = event.getPoseStack();
            EntityDimensions dimensions = player.getDimensions(player.getPose());
            MultiBufferSource multiBufferSource = event.getMultiBufferSource();
            EntityRenderDispatcher renderDispatcher = mc.getEntityRenderDispatcher();
            double nameOffset = ClientHandler.getNameOffset(renderDispatcher, (LivingEntity)player);
            BubbleRenderer.renderBubbleText(bubble, poseStack, font, multiBufferSource, renderDispatcher, dimensions.height, bubbleAlpha, event.getPackedLight(), nameOffset);
            if (bubbleAge > bubbleTime) {
                BubbleHandler.removePlayerBubble(bubble);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerReceiveChat(ClientChatReceivedEvent.Player event) {
        if (!ConfigCache.renderPlayerBubbles) {
            return;
        }
        UUID sender = event.getSender();
        Component message = event.getMessage();
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            return;
        }
        Player senderPlayer = level.getPlayerByUUID(sender);
        if (senderPlayer == null) {
            return;
        }
        if (player.blockPosition().distManhattan((Vec3i)senderPlayer.blockPosition()) < 2000 || player.level().dimension().location().equals((Object)senderPlayer.level().dimension().location())) {
            TranslatableContents translatableContents;
            Object[] args;
            ComponentContents componentContents;
            boolean showUsername;
            String lastText;
            String senderName = senderPlayer.getGameProfile().getName();
            String messageText = message.getString();
            List siblings = message.getSiblings();
            if (!siblings.isEmpty() && !(lastText = ((Component)siblings.get(siblings.size() - 1)).getString()).isEmpty()) {
                messageText = lastText;
            }
            if (!(showUsername = ConfigCache.showUsername) && (componentContents = message.getContents()) instanceof TranslatableContents && (args = (translatableContents = (TranslatableContents)componentContents).getArgs()).length > 1) {
                Object[] adjustedArgs = Arrays.copyOfRange(args, 1, args.length);
                StringBuilder justTheMessage = new StringBuilder();
                for (Object adjustedArg : adjustedArgs) {
                    if (adjustedArg instanceof Component) {
                        Component component = (Component)adjustedArg;
                        justTheMessage.append(component.getString());
                    }
                    if (!(adjustedArg instanceof String)) continue;
                    String str = (String)adjustedArg;
                    justTheMessage.append(str);
                }
                messageText = justTheMessage.toString();
            }
            if (!BubbleHandler.addPlayerBubble(sender, new BubbleText(senderName, messageText, sender, level.getGameTime()))) {
                NotableBubbleText.LOGGER.error("Failed to add player bubble for {}", (Object)senderName);
            }
        }
    }
}

