/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.client.compat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mrbysco.nbt.client.BubbleHandler;
import com.mrbysco.nbt.client.ClientHandler;
import com.mrbysco.nbt.client.util.BubbleRenderer;
import com.mrbysco.nbt.command.BubbleText;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import software.bernie.geckolib.event.GeoRenderEvent;

public class GeckoCompat {
    @SubscribeEvent
    public void onEntityRender(GeoRenderEvent.Entity.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer localPlayer = mc.player;
        if (localPlayer == null) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.isInvisibleTo((Player)localPlayer)) {
                return;
            }
            String author = BubbleHandler.getAuthor(livingEntity.getUUID());
            if (!author.isEmpty()) {
                List<BubbleText> bubbles = BubbleHandler.getBubbles(author);
                if (bubbles.isEmpty()) {
                    return;
                }
                BubbleText bubble = bubbles.get(0);
                ClientLevel level = mc.level;
                if (level == null) {
                    return;
                }
                long currentTime = level.getGameTime();
                long bubbleTime = bubbles.size() > 1 ? 50L : 200L;
                long bubbleAge = bubble.getAge(currentTime);
                float bubbleAlpha = bubble.getAlpha(currentTime);
                Font font = mc.font;
                PoseStack poseStack = event.getPoseStack();
                EntityDimensions dimensions = livingEntity.getDimensions(livingEntity.getPose());
                MultiBufferSource multiBufferSource = event.getBufferSource();
                EntityRenderDispatcher renderDispatcher = mc.getEntityRenderDispatcher();
                double nameOffset = ClientHandler.getNameOffset(renderDispatcher, livingEntity);
                BubbleRenderer.renderBubbleText(bubble, poseStack, font, multiBufferSource, renderDispatcher, dimensions.height, bubbleAlpha, event.getPackedLight(), nameOffset);
                if (bubbleAge > bubbleTime) {
                    BubbleHandler.removeBubble(bubble);
                }
            }
        }
    }
}

