/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.client.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mrbysco.nbt.client.ConfigCache;
import com.mrbysco.nbt.client.util.BubbleRenderType;
import com.mrbysco.nbt.command.BubbleText;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.joml.Matrix4f;

public class BubbleRenderer {
    private static final ResourceLocation BUBBLE_TEXTURE = new ResourceLocation("nbt", "textures/block/bubble.png");

    public static void renderBubbleText(BubbleText bubble, PoseStack poseStack, Font font, MultiBufferSource buffer, EntityRenderDispatcher renderDispatcher, float entityHeight, float alpha, int light, double nameOffset) {
        String text = bubble.text();
        MutableComponent component = Component.literal((String)text).withStyle(ChatFormatting.BLACK);
        List sequences = font.split((FormattedText)component, ConfigCache.maxTextWidth);
        int textWidth = 0;
        Objects.requireNonNull(font);
        int textHeight = 9 * sequences.size();
        for (FormattedCharSequence sequence : sequences) {
            textWidth = Math.max(textWidth, font.width(sequence));
        }
        poseStack.pushPose();
        Matrix4f pose = poseStack.last().pose();
        poseStack.translate(0.0, (double)entityHeight + (ConfigCache.bubbleOffset + nameOffset), 0.0);
        if (sequences.size() > 1) {
            poseStack.translate(0.0, (double)(0.1f * (float)sequences.size()), 0.0);
        }
        poseStack.mulPose(renderDispatcher.cameraOrientation());
        poseStack.scale(-0.025f, -0.025f, -0.025f);
        RenderType bubbleType = BubbleRenderType.bubble(BUBBLE_TEXTURE);
        VertexConsumer bubbleBuffer = buffer.getBuffer(bubbleType);
        BubbleRenderer.renderBubble(poseStack, pose, bubbleBuffer, textWidth, textHeight, alpha, light);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource source = (MultiBufferSource.BufferSource)buffer;
            source.endBatch(bubbleType);
        }
        poseStack.translate(0.0, 0.0, 0.01);
        for (int i = 0; i < sequences.size(); ++i) {
            FormattedCharSequence sequence = (FormattedCharSequence)sequences.get(i);
            float offset = 0.0f;
            if (sequences.size() > 1) {
                Objects.requireNonNull(font);
                offset += (float)(9 * i + 2);
                offset += -4.0f * (float)sequences.size();
            }
            if (sequence == null) continue;
            font.drawInBatch(sequence, 0.0f, offset, -1, false, pose, buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
    }

    public static void renderBubble(PoseStack poseStack, Matrix4f pose, VertexConsumer bubbleBuffer, int textWidth, int textHeight, float alpha, int light) {
        int imageSize = 32;
        float xOffset = -textWidth + 3;
        poseStack.pushPose();
        float height = textHeight - 6;
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth + 3) - xOffset, (float)(-textHeight) / 2.0f, 7.0f, 0.0f, 1.0f, 6.0f, textWidth, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth - 3) - xOffset, (float)(-textHeight) / 2.0f + 6.0f, 0.0f, 7.0f, 6.0f, 1.0f, 6.0f, textHeight - 6, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth + 3) - xOffset, (float)(-textHeight) / 2.0f + 6.0f, 7.0f, 7.0f, 1.0f, 1.0f, textWidth, height, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, 3.0f - xOffset, (float)(-textHeight) / 2.0f + 6.0f, 9.0f, 7.0f, 6.0f, 1.0f, 6.0f, height, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth + 3) - xOffset, (float)textHeight / 2.0f, 7.0f, 9.0f, 1.0f, 6.0f, textWidth, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth - 3) - xOffset, (float)(-textHeight) / 2.0f, 0.0f, 0.0f, 6.0f, 6.0f, 6.0f, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, 3.0f - xOffset, (float)(-textHeight) / 2.0f, 9.0f, 0.0f, 6.0f, 6.0f, 6.0f, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, (float)(-textWidth - 3) - xOffset, (float)textHeight / 2.0f, 0.0f, 9.0f, 6.0f, 6.0f, 6.0f, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, 3.0f - xOffset, (float)textHeight / 2.0f, 9.0f, 9.0f, 6.0f, 6.0f, 6.0f, 6.0f, 32.0f, 32.0f, alpha, light);
        BubbleRenderer.drawTexture(pose, bubbleBuffer, 3.0f, (float)textHeight / 2.0f + 5.0f, 0.1f, 0.0f, 16.0f, 5.0f, 5.0f, 5.0f, 5.0f, 32.0f, 32.0f, alpha, light);
        poseStack.popPose();
    }

    public static void drawTexture(Matrix4f pose, VertexConsumer vertexConsumer, float x, float y, float u, float v, float uWidth, float vHeight, float renderWidth, float renderHeight, float textureWidth, float textureHeight, float alpha, int light) {
        BubbleRenderer.drawTexture(pose, vertexConsumer, x, y, 0.0f, u, v, uWidth, vHeight, renderWidth, renderHeight, textureWidth, textureHeight, alpha, light);
    }

    public static void drawTexture(Matrix4f pose, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v, float uWidth, float vHeight, float renderWidth, float renderHeight, float textureWidth, float textureHeight, float alpha, int light) {
        float wRatio = 1.0f / textureWidth;
        float hRatio = 1.0f / textureHeight;
        vertexConsumer.vertex(pose, x, y + renderHeight, z).color(1.0f, 1.0f, 1.0f, alpha).uv(u * wRatio, (v + vHeight) * hRatio).uv2(light).overlayCoords(OverlayTexture.NO_OVERLAY).endVertex();
        vertexConsumer.vertex(pose, x + renderWidth, y + renderHeight, z).color(1.0f, 1.0f, 1.0f, alpha).uv((u + uWidth) * wRatio, (v + vHeight) * hRatio).uv2(light).overlayCoords(OverlayTexture.NO_OVERLAY).endVertex();
        vertexConsumer.vertex(pose, x + renderWidth, y, z).color(1.0f, 1.0f, 1.0f, alpha).uv((u + uWidth) * wRatio, v * hRatio).uv2(light).overlayCoords(OverlayTexture.NO_OVERLAY).endVertex();
        vertexConsumer.vertex(pose, x, y, z).color(1.0f, 1.0f, 1.0f, alpha).uv(u * wRatio, v * hRatio).uv2(light).overlayCoords(OverlayTexture.NO_OVERLAY).endVertex();
    }
}

