/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mrbysco.nbt.NotableBubbleText;
import com.mrbysco.nbt.config.BubbleConfig;
import com.mrbysco.nbt.network.message.AddBubblePayload;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class BubbleCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"bubbletext");
        ((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.argument((String)"author", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"text", (ArgumentType)MessageArgument.message()).executes(BubbleCommands::addBubble)));
        dispatcher.register(root);
    }

    private static int addBubble(CommandContext<CommandSourceStack> ctx) {
        String author = StringArgumentType.getString(ctx, (String)"author");
        String text = "";
        try {
            text = MessageArgument.getMessage(ctx, (String)"text").getString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String finalText = text;
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        String bubbleKey = (String)BubbleConfig.COMMON.nameKey.get();
        server.getAllLevels().forEach(level -> {
            if (level.players().isEmpty()) {
                return;
            }
            List playerList = level.players();
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            level.getAllEntities().forEach(entityList::add);
            entityList.removeIf(entity -> !entity.getPersistentData().contains(bubbleKey) || !entity.getPersistentData().getString(bubbleKey).equals(author));
            for (ServerPlayer player : playerList) {
                UUID uuid = null;
                for (Entity entity2 : entityList) {
                    if (entity2.blockPosition().distManhattan((Vec3i)player.blockPosition()) >= 2000) continue;
                    uuid = entity2.getUUID();
                    break;
                }
                if (uuid == null) {
                    NotableBubbleText.LOGGER.debug("Ignoring bubble for {} because no entity was found", (Object)player.getName().getString());
                    continue;
                }
                player.connection.send((CustomPacketPayload)new AddBubblePayload(uuid, author, finalText));
            }
        });
        return 0;
    }
}

