/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.config;

import com.mrbysco.nbt.NotableBubbleText;
import com.mrbysco.nbt.client.ConfigCache;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class BubbleConfig {
    public static final ModConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        NotableBubbleText.LOGGER.debug("Loaded Notable Bubble Text's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        NotableBubbleText.LOGGER.debug("MNotable Bubble Text's config just got changed on the file system!");
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        BubbleConfig.refreshCache(config.getType());
    }

    private static void refreshCache(ModConfig.Type type) {
        if (type == ModConfig.Type.CLIENT) {
            ConfigCache.setRenderPlayerBubbles((Boolean)BubbleConfig.CLIENT.playerBubbles.get());
            ConfigCache.setNameOffset((Boolean)BubbleConfig.CLIENT.nameOffset.get());
            ConfigCache.setMaxTextWidth((Integer)BubbleConfig.CLIENT.maxTextWidth.get());
            ConfigCache.setBubbleOffset((Double)BubbleConfig.CLIENT.yOffset.get());
            ConfigCache.setShowUsername((Boolean)BubbleConfig.CLIENT.showUsername.get());
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Client::new);
        clientSpec = (ModConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        public final ModConfigSpec.IntValue maxTextWidth;
        public final ModConfigSpec.DoubleValue yOffset;
        public final ModConfigSpec.BooleanValue playerBubbles;
        public final ModConfigSpec.BooleanValue nameOffset;
        public final ModConfigSpec.BooleanValue showUsername;

        Client(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.maxTextWidth = builder.comment("The maximum width of the bubble text before it wraps to a new line").defineInRange("maxTextWidth", 200, 10, 512);
            this.yOffset = builder.comment("The offset above the entity's head at which the bubble renders").defineInRange("YOffset", 0.5, 0.0, 10.0);
            this.playerBubbles = builder.comment("Render chat messages above players heads in a bubble").define("playerBubbles", true);
            this.nameOffset = builder.comment("Offset the bubble text if the entity's name is rendered above their head").define("nameOffset", true);
            this.showUsername = builder.comment("Show the username of the player who sent the message in the bubble").define("showUsername", true);
            builder.pop();
        }
    }

    public static class Common {
        public final ModConfigSpec.ConfigValue<? extends String> nameKey;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("General");
            this.nameKey = builder.comment("The name for the key used to store the bubble owners' name in the entity's persistent data").define("nameKey", (Object)"BubbleOwner");
            builder.pop();
        }
    }
}

