/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.nbt.network.handler;

import com.mrbysco.nbt.NotableBubbleText;
import com.mrbysco.nbt.client.BubbleHandler;
import com.mrbysco.nbt.command.BubbleText;
import com.mrbysco.nbt.network.message.AddBubblePayload;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleData(AddBubblePayload data, PlayPayloadContext context) {
        context.workHandler().submitAsync(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level == null) {
                return;
            }
            String author = data.author();
            String message = data.message();
            UUID mobUUID = data.mobUUID();
            if (!BubbleHandler.addBubble(data.author(), new BubbleText(author, message, mobUUID, level.getGameTime()))) {
                NotableBubbleText.LOGGER.error("Failed to add bubble for {}", (Object)author);
            }
        }).exceptionally(e -> {
            context.packetHandler().disconnect((Component)Component.translatable((String)"nbt.networking.add_bubble.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

