/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.platform;

import it.crystalnest.cobweb.api.item.TierUtils;
import it.crystalnest.cobweb.platform.services.ToolTiersHelper;
import java.util.Collection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.common.TierSortingRegistry;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeToolTiersHelper
implements ToolTiersHelper {
    @Override
    public Collection<Tier> getAllTiers() {
        return TierSortingRegistry.getSortedTiers();
    }

    @Override
    public int getLevel(Tier tier) {
        return tier == null || tier == TierUtils.NO_TIER ? -1 : TierSortingRegistry.getTiersLowerThan((Tier)tier).size() + 1;
    }

    @Override
    @Nullable
    public Tier getTier(ResourceLocation reference) {
        return TierSortingRegistry.byName((ResourceLocation)reference);
    }

    @Override
    @Nullable
    public Tier getTier(String reference) {
        return "none".equalsIgnoreCase(reference) ? TierUtils.NO_TIER : (ResourceLocation.isValidResourceLocation((String)reference) ? TierSortingRegistry.byName((ResourceLocation)new ResourceLocation(reference)) : null);
    }

    @Override
    public boolean matches(Tier tier, String reference) {
        ResourceLocation id = TierSortingRegistry.getName((Tier)tier);
        return tier.toString().equalsIgnoreCase(reference) || id != null && id.toString().equalsIgnoreCase(reference);
    }
}

