/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.platform;

import it.crystalnest.cobweb.Constants;
import it.crystalnest.cobweb.platform.model.Platform;
import it.crystalnest.cobweb.platform.services.ConfigHelper;
import it.crystalnest.cobweb.platform.services.PlatformHelper;
import it.crystalnest.cobweb.platform.services.RegistryHelper;
import it.crystalnest.cobweb.platform.services.ToolTiersHelper;
import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class Services {
    public static final PlatformHelper PLATFORM = Services.load(PlatformHelper.class);
    public static final ToolTiersHelper TOOL_TIERS = Services.load(ToolTiersHelper.class);
    public static final RegistryHelper<?> REGISTRY = Services.load(RegistryHelper.class);
    @Nullable
    public static final ConfigHelper CONFIG = PLATFORM.getPlatformName() == Platform.NEOFORGE || PLATFORM.isModLoaded("forgeconfigapiport") ? Services.load(ConfigHelper.class) : null;

    private Services() {
    }

    private static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

