/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CabinetBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CabinetBlock
extends CounterBlock {
    public static final MapCodec<CabinetBlock> CODEC = CabinetBlock.simpleCodec(CabinetBlock::new);
    private static final VoxelShape BOUNDING_BOX_NORTH = Block.box((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_EAST = Block.box((double)0.0, (double)2.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_WEST = Block.box((double)2.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOUNDING_BOX_SOUTH = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);

    public CabinetBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CabinetBlockEntity(pos, state);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.EAST -> BOUNDING_BOX_EAST;
            case Direction.WEST -> BOUNDING_BOX_WEST;
            case Direction.SOUTH -> BOUNDING_BOX_SOUTH;
            default -> BOUNDING_BOX_NORTH;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? CabinetBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.cabinet.get()), CounterBlockEntity::clientTick) : CabinetBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.cabinet.get()), CounterBlockEntity::serverTick);
    }

    @Override
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.cabinet.description").withStyle(ChatFormatting.GRAY));
    }
}

