/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CounterBlock
extends BaseKitchenBlock {
    public static final MapCodec<CounterBlock> CODEC = CounterBlock.simpleCodec(CounterBlock::new);

    public CounterBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.STONE).strength(5.0f, 10.0f));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, FLIPPED, COLOR, HAS_COLOR});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CounterBlockEntity(pos, state);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (this.tryRecolorBlock(state, heldItem, level, pos, player, rayTraceResult)) {
            return InteractionResult.SUCCESS;
        }
        CounterBlockEntity counter = (CounterBlockEntity)level.getBlockEntity(pos);
        if (rayTraceResult.getDirection() == state.getValue((Property)FACING) && counter != null) {
            if (player.isShiftKeyDown()) {
                counter.getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && counter.getDoorAnimator().isForcedOpen()) {
                heldItem = counter.insertItemStacked(heldItem, false);
                player.setItemInHand(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.isClientSide) {
            if (rayTraceResult.getDirection() == Direction.UP && !heldItem.isEmpty() && heldItem.getItem() instanceof BlockItem) {
                return InteractionResult.FAIL;
            }
            Balm.getNetworking().openGui(player, (MenuProvider)counter);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.getValue((Property)FACING))));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? CounterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::clientTick) : CounterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.counter.get()), CounterBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.counter.description").withStyle(ChatFormatting.GRAY));
    }
}

