/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.item.ModItems;
import net.blay09.mods.cookingforblockheads.util.ItemUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FridgeBlock
extends BaseKitchenBlock {
    public static final MapCodec<FridgeBlock> CODEC = FridgeBlock.simpleCodec(FridgeBlock::new);
    public static final EnumProperty<FridgeModelType> MODEL_TYPE = EnumProperty.create((String)"model", FridgeModelType.class);
    public static final BooleanProperty PRESERVATION_CHAMBER = BooleanProperty.create((String)"preservation_chamber");
    public static final BooleanProperty ICE_UNIT = BooleanProperty.create((String)"ice_unit");

    public FridgeBlock(BlockBehaviour.Properties properties) {
        super(properties.pushReaction(PushReaction.BLOCK).sound(SoundType.METAL).strength(5.0f, 10.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)PRESERVATION_CHAMBER, (Comparable)Boolean.valueOf(false))).setValue((Property)ICE_UNIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MODEL_TYPE, FLIPPED, PRESERVATION_CHAMBER, ICE_UNIT, COLOR, HAS_COLOR});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FridgeBlockEntity(pos, state);
    }

    public InteractionResult use(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() == ModItems.preservationChamber || heldItem.getItem() == ModItems.iceUnit) {
            return InteractionResult.PASS;
        }
        if (this.tryRecolorBlock(state, heldItem, level, pos, player, rayTraceResult)) {
            return InteractionResult.SUCCESS;
        }
        FridgeBlockEntity fridge = (FridgeBlockEntity)level.getBlockEntity(pos);
        Direction frontFace = (Direction)state.getValue((Property)FACING);
        if (rayTraceResult.getDirection() == frontFace && fridge != null) {
            if (player.isShiftKeyDown()) {
                fridge.getBaseFridge().getDoorAnimator().toggleForcedOpen();
                return InteractionResult.SUCCESS;
            }
            if (!heldItem.isEmpty() && fridge.getBaseFridge().getDoorAnimator().isForcedOpen()) {
                heldItem = fridge.insertItemStacked(heldItem, false);
                player.setItemInHand(hand, heldItem);
                return InteractionResult.SUCCESS;
            }
        }
        if (!level.isClientSide) {
            if (!heldItem.isEmpty() && Block.byItem((Item)heldItem.getItem()) instanceof FridgeBlock && rayTraceResult.getDirection() != frontFace) {
                return InteractionResult.FAIL;
            }
            Balm.getNetworking().openGui(player, (MenuProvider)fridge);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        boolean below = level.getBlockState(pos.below()).getBlock() instanceof FridgeBlock;
        boolean above = level.getBlockState(pos.above()).getBlock() instanceof FridgeBlock;
        return !(below && above || below && level.getBlockState(pos.below(2)).getBlock() instanceof FridgeBlock || above && level.getBlockState(pos.above(2)).getBlock() instanceof FridgeBlock || !super.canSurvive(state, level, pos));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return (BlockState)state.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(this.shouldBePlacedFlipped(context, (Direction)state.getValue((Property)FACING))));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        BlockPos posBelow = currentPos.below();
        BlockState stateBelow = world.getBlockState(posBelow);
        BlockPos posAbove = currentPos.above();
        BlockState stateAbove = world.getBlockState(posAbove);
        if (stateBelow.getBlock() == ModBlocks.fridge && stateBelow.getValue(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.setBlock(posBelow, (BlockState)((BlockState)stateBelow.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
            return (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER));
        }
        if (stateAbove.getBlock() == ModBlocks.fridge && stateAbove.getValue(MODEL_TYPE) == FridgeModelType.SMALL) {
            world.setBlock(posAbove, (BlockState)((BlockState)stateAbove.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_UPPER))).setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))), 3);
            return (BlockState)state.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.LARGE_LOWER));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof FridgeBlockEntity) {
                if (((FridgeBlockEntity)blockEntity).hasIceUpgrade()) {
                    ItemUtils.spawnItemStack(level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.iceUnit));
                }
                if (((FridgeBlockEntity)blockEntity).hasPreservationUpgrade()) {
                    ItemUtils.spawnItemStack(level, (float)pos.getX() + 0.5f, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)ModItems.preservationChamber));
                }
            }
            BlockPos posAbove = pos.above();
            BlockState stateAbove = level.getBlockState(posAbove);
            BlockPos posBelow = pos.below();
            BlockState stateBelow = level.getBlockState(posBelow);
            if (stateAbove.getBlock() == ModBlocks.fridge && stateAbove.getValue(MODEL_TYPE) == FridgeModelType.LARGE_UPPER) {
                level.setBlock(posAbove, (BlockState)stateAbove.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            } else if (stateBelow.getBlock() == ModBlocks.fridge && stateBelow.getValue(MODEL_TYPE) == FridgeModelType.LARGE_LOWER) {
                level.setBlock(posBelow, (BlockState)stateBelow.setValue(MODEL_TYPE, (Comparable)((Object)FridgeModelType.SMALL)), 3);
            }
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? FridgeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::clientTick) : FridgeBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.fridge.get()), FridgeBlockEntity::serverTick);
    }

    @Override
    protected boolean recolorBlock(BlockState state, LevelAccessor world, BlockPos pos, Direction facing, DyeColor color) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            BlockPos bottomPos = fridge.getBaseFridge().getBlockPos();
            BlockPos topPos = bottomPos.above();
            return super.recolorBlock(world.getBlockState(bottomPos), world, bottomPos, facing, color) && super.recolorBlock(world.getBlockState(topPos), world, topPos, facing, color);
        }
        return false;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    protected void appendHoverDescriptionText(ItemStack itemStack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.cookingforblockheads.fridge.description").withStyle(ChatFormatting.GRAY));
    }

    public static enum FridgeModelType implements StringRepresentable
    {
        SMALL,
        LARGE_LOWER,
        LARGE_UPPER;


        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

