/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.cookingforblockheads.block.CabinetBlock;
import net.blay09.mods.cookingforblockheads.block.ConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.CookingTableBlock;
import net.blay09.mods.cookingforblockheads.block.CounterBlock;
import net.blay09.mods.cookingforblockheads.block.CowJarBlock;
import net.blay09.mods.cookingforblockheads.block.CuttingBoardBlock;
import net.blay09.mods.cookingforblockheads.block.DyedConnectorBlock;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.FruitBasketBlock;
import net.blay09.mods.cookingforblockheads.block.KitchenFloorBlock;
import net.blay09.mods.cookingforblockheads.block.MilkJarBlock;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.SpiceRackBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.ToolRackBlock;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class ModBlocks {
    public static OvenBlock[] ovens = new OvenBlock[DyeColor.values().length];
    public static Block toolRack;
    public static Block toaster;
    public static Block milkJar;
    public static Block cowJar;
    public static Block spiceRack;
    public static Block fruitBasket;
    public static Block cuttingBoard;
    public static Block cookingTable;
    public static Block fridge;
    public static Block sink;
    public static Block counter;
    public static Block cabinet;
    public static Block connector;
    public static DyedConnectorBlock[] connectors;
    public static Block[] kitchenFloors;

    public static void initialize(BalmBlocks blocks) {
        String colorPrefix;
        blocks.register(() -> {
            toolRack = new ToolRackBlock(ModBlocks.defaultProperties());
            return toolRack;
        }, () -> ModBlocks.itemBlock(toolRack), ModBlocks.id("tool_rack"));
        blocks.register(() -> {
            toaster = new ToasterBlock(ModBlocks.defaultProperties());
            return toaster;
        }, () -> ModBlocks.itemBlock(toaster), ModBlocks.id("toaster"));
        blocks.register(() -> {
            milkJar = new MilkJarBlock(ModBlocks.defaultProperties());
            return milkJar;
        }, () -> ModBlocks.itemBlock(milkJar), ModBlocks.id("milk_jar"));
        blocks.register(() -> {
            cowJar = new CowJarBlock(ModBlocks.defaultProperties());
            return cowJar;
        }, () -> ModBlocks.itemBlock(cowJar), ModBlocks.id("cow_jar"));
        blocks.register(() -> {
            spiceRack = new SpiceRackBlock(ModBlocks.defaultProperties());
            return spiceRack;
        }, () -> ModBlocks.itemBlock(spiceRack), ModBlocks.id("spice_rack"));
        blocks.register(() -> {
            fruitBasket = new FruitBasketBlock(ModBlocks.defaultProperties());
            return fruitBasket;
        }, () -> ModBlocks.itemBlock(fruitBasket), ModBlocks.id("fruit_basket"));
        blocks.register(() -> {
            cuttingBoard = new CuttingBoardBlock(ModBlocks.defaultProperties());
            return cuttingBoard;
        }, () -> ModBlocks.itemBlock(cuttingBoard), ModBlocks.id("cutting_board"));
        blocks.register(() -> {
            cookingTable = new CookingTableBlock(ModBlocks.defaultProperties());
            return cookingTable;
        }, () -> ModBlocks.itemBlock(cookingTable), ModBlocks.id("cooking_table"));
        blocks.register(() -> {
            fridge = new FridgeBlock(ModBlocks.defaultProperties());
            return fridge;
        }, () -> ModBlocks.itemBlock(fridge), ModBlocks.id("fridge"));
        blocks.register(() -> {
            sink = new SinkBlock(ModBlocks.defaultProperties());
            return sink;
        }, () -> ModBlocks.itemBlock(sink), ModBlocks.id("sink"));
        blocks.register(() -> {
            counter = new CounterBlock(ModBlocks.defaultProperties());
            return counter;
        }, () -> ModBlocks.itemBlock(counter), ModBlocks.id("counter"));
        blocks.register(() -> {
            cabinet = new CabinetBlock(ModBlocks.defaultProperties());
            return cabinet;
        }, () -> ModBlocks.itemBlock(cabinet), ModBlocks.id("cabinet"));
        DyeColor[] colors = DyeColor.values();
        kitchenFloors = new Block[colors.length];
        ovens = new OvenBlock[colors.length];
        connectors = new DyedConnectorBlock[colors.length];
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            Object colorPrefixExceptWhite = color == DyeColor.WHITE ? "" : colorPrefix;
            blocks.register(() -> {
                OvenBlock ovenBlock = new OvenBlock(color, ModBlocks.defaultProperties());
                ModBlocks.ovens[color.ordinal()] = ovenBlock;
                return ovenBlock;
            }, () -> ModBlocks.itemBlock((Block)ovens[color.ordinal()]), ModBlocks.id((String)colorPrefixExceptWhite + "oven"));
        }
        blocks.register(() -> {
            connector = new ConnectorBlock(ModBlocks.defaultProperties());
            return connector;
        }, () -> ModBlocks.itemBlock(connector), ModBlocks.id("connector"));
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                DyedConnectorBlock dyedConnectorBlock = new DyedConnectorBlock(color, ModBlocks.defaultProperties());
                ModBlocks.connectors[color.ordinal()] = dyedConnectorBlock;
                return dyedConnectorBlock;
            }, () -> ModBlocks.itemBlock((Block)connectors[color.ordinal()]), ModBlocks.id(colorPrefix + "connector"));
        }
        for (DyeColor color : colors) {
            colorPrefix = color.getSerializedName() + "_";
            blocks.register(() -> {
                KitchenFloorBlock kitchenFloorBlock = new KitchenFloorBlock(ModBlocks.defaultProperties());
                ModBlocks.kitchenFloors[color.ordinal()] = kitchenFloorBlock;
                return kitchenFloorBlock;
            }, () -> ModBlocks.itemBlock(kitchenFloors[color.ordinal()]), ModBlocks.id(colorPrefix + "kitchen_floor"));
        }
    }

    private static BlockItem itemBlock(Block block) {
        return new BlockItem(block, Balm.getItems().itemProperties());
    }

    private static ResourceLocation id(String name) {
        return new ResourceLocation("cookingforblockheads", name);
    }

    private static BlockBehaviour.Properties defaultProperties() {
        return Balm.getBlocks().blockProperties();
    }

    static {
        connectors = new DyedConnectorBlock[DyeColor.values().length];
        kitchenFloors = new Block[DyeColor.values().length];
    }
}

