/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CookingTableBlockEntity
extends BalmBlockEntity
implements BalmMenuProvider {
    private ItemStack noFilterBook = ItemStack.EMPTY;

    public CookingTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.cookingTable.get(), pos, state);
    }

    public boolean hasNoFilterBook() {
        return !this.noFilterBook.isEmpty();
    }

    public ItemStack getNoFilterBook() {
        return this.noFilterBook;
    }

    public void setNoFilterBook(ItemStack noFilterBook) {
        this.noFilterBook = noFilterBook;
        this.setChanged();
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        CompoundTag itemCompound = new CompoundTag();
        if (!this.noFilterBook.isEmpty()) {
            this.noFilterBook.save(itemCompound);
        }
        tag.put("NoFilterBook", (Tag)itemCompound);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        if (tag.contains("NoFilterBook")) {
            this.setNoFilterBook(ItemStack.of((CompoundTag)tag.getCompound("NoFilterBook")));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.cookingforblockheads.cooking_table");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)ModMenus.cookingTable.get()), i, player, new KitchenImpl(this.level, this.worldPosition));
    }

    public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
        buf.writeBlockPos(this.worldPosition);
    }
}

