/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.balm.api.fluid.BalmFluidTankProvider;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.CacheHint;
import net.blay09.mods.cookingforblockheads.api.IngredientToken;
import net.blay09.mods.cookingforblockheads.api.KitchenItemProvider;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class SinkBlockEntity
extends BalmBlockEntity
implements BalmFluidTankProvider {
    private static final int SYNC_INTERVAL = 10;
    private final FluidTank sinkTank = new FluidTank(16000){

        public Fluid getFluid() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Fluids.WATER;
            }
            return super.getFluid();
        }

        public int getAmount() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getAmount();
        }

        public int getCapacity() {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return Integer.MAX_VALUE;
            }
            return super.getCapacity();
        }

        public int drain(Fluid fluid, int maxDrain, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater && fluid == Fluids.WATER) {
                return maxDrain;
            }
            if (fluid.isSame(Fluids.EMPTY) || !fluid.isSame(fluid)) {
                return 0;
            }
            SinkBlockEntity.this.setChanged();
            return super.drain(fluid, maxDrain, simulate);
        }

        public int fill(Fluid fluid, int maxFill, boolean simulate) {
            if (!CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                return maxFill;
            }
            SinkBlockEntity.this.setChanged();
            return super.fill(fluid, maxFill, simulate);
        }
    };
    private final SinkItemProvider itemProvider = new SinkItemProvider(this);
    private int ticksSinceSync;
    private boolean isDirty;
    private DyeColor color = DyeColor.WHITE;

    public SinkBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.sink.get(), pos, state);
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("FluidTank", (Tag)this.sinkTank.serialize());
        tag.putByte("Color", (byte)this.color.getId());
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.sinkTank.deserialize(tag.getCompound("FluidTank"));
        this.color = DyeColor.byId((int)tag.getByte("Color"));
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
    }

    public List<BalmProvider<?>> getProviders() {
        return Lists.newArrayList((Object[])new BalmProvider[]{new BalmProvider(KitchenItemProvider.class, (Object)this.itemProvider)});
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SinkBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        ++this.ticksSinceSync;
        if (this.ticksSinceSync >= 10) {
            this.ticksSinceSync = 0;
            if (this.isDirty) {
                this.sync();
                this.isDirty = false;
            }
        }
    }

    public void setChanged() {
        super.setChanged();
        this.isDirty = true;
    }

    public FluidTank getFluidTank() {
        return this.sinkTank;
    }

    private record SinkItemProvider(SinkBlockEntity sink) implements KitchenItemProvider
    {
        @Override
        public IngredientToken findIngredient(Ingredient ingredient, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            for (ItemStack itemStack : ingredient.getItems()) {
                IngredientToken found = this.findIngredient(itemStack, ingredientTokens, cacheHint);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        @Override
        public IngredientToken findIngredient(ItemStack itemStack, Collection<IngredientToken> ingredientTokens, CacheHint cacheHint) {
            if (!itemStack.is(ModItemTags.WATER)) {
                return null;
            }
            int milkUnitsUsed = ingredientTokens.size();
            int milkUnitsAvailable = this.sink.getFluidTank().getAmount() / 1000 - milkUnitsUsed;
            if (milkUnitsAvailable > 1) {
                return new SinkIngredientToken(this.sink, itemStack);
            }
            return null;
        }

        @Override
        public CacheHint getCacheHint(IngredientToken ingredientToken) {
            return CacheHint.NONE;
        }
    }

    private record SinkIngredientToken(SinkBlockEntity milkJar, ItemStack itemStack) implements IngredientToken
    {
        @Override
        public ItemStack peek() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, true);
            return drained >= 1000 ? this.itemStack : ItemStack.EMPTY;
        }

        @Override
        public ItemStack consume() {
            int drained = this.milkJar.getFluidTank().drain(Compat.getMilkFluid(), 1000, false);
            return drained >= 1000 ? this.itemStack : ItemStack.EMPTY;
        }

        @Override
        public ItemStack restore(ItemStack itemStack) {
            this.milkJar.getFluidTank().fill(Compat.getMilkFluid(), 1000, false);
            return ItemStack.EMPTY;
        }
    }
}

