/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.block.entity;

import java.util.List;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.common.BalmBlockEntity;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.blay09.mods.cookingforblockheads.block.entity.ModBlockEntities;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.blay09.mods.cookingforblockheads.recipe.ToasterRecipe;
import net.blay09.mods.cookingforblockheads.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ToasterBlockEntity
extends BalmBlockEntity {
    private static final int UPDATE_INTERVAL = 20;
    private static final int TOAST_TICKS = 1200;
    private final DefaultContainer container = new DefaultContainer(2){

        public void setChanged() {
            ToasterBlockEntity.this.setChanged();
            ToasterBlockEntity.this.sync();
        }
    };
    private boolean isDirty;
    private int ticksSinceUpdate;
    private boolean active;
    private int toastTicks;

    public ToasterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.toaster.get(), pos, state);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 0) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.toasterStart.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 1) {
            this.level.playSound(null, this.worldPosition, (SoundEvent)ModSounds.toasterStop.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return true;
        }
        if (id == 2) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void load(CompoundTag tagCompound) {
        super.load(tagCompound);
        this.container.deserialize(tagCompound.getCompound("ItemHandler"));
        this.active = tagCompound.getBoolean("Active");
        this.toastTicks = tagCompound.getInt("ToastTicks");
    }

    public void saveAdditional(CompoundTag tag) {
        super.saveAdditional(tag);
        tag.put("ItemHandler", (Tag)this.container.serialize());
        tag.putBoolean("Active", this.active);
        tag.putInt("ToastTicks", this.toastTicks);
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.saveAdditional(tag);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ToasterBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.active) {
            --this.toastTicks;
            if (this.toastTicks <= 0 && !level.isClientSide) {
                for (int i = 0; i < this.container.getContainerSize(); ++i) {
                    ItemStack inputStack = this.container.getItem(i);
                    if (inputStack.isEmpty()) continue;
                    ItemStack outputStack = this.toastItem(inputStack);
                    ItemEntity itemEntity = new ItemEntity(level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 0.75f), (double)((float)this.worldPosition.getZ() + 0.5f), outputStack);
                    itemEntity.setDeltaMovement(0.0, (double)0.1f, 0.0);
                    level.addFreshEntity((Entity)itemEntity);
                    this.container.setItem(i, ItemStack.EMPTY);
                }
                this.setActive(false);
            }
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public void setActive(boolean active) {
        this.active = active;
        if (active) {
            this.toastTicks = 1200;
            this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 0, 0);
        } else {
            this.toastTicks = 0;
            this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 1, 0);
        }
        this.level.blockEvent(this.worldPosition, ModBlocks.toaster, 2, 0);
        BlockState state = this.level.getBlockState(this.worldPosition);
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)ToasterBlock.ACTIVE, (Comparable)Boolean.valueOf(active)));
        this.isDirty = true;
        this.setChanged();
    }

    public boolean isActive() {
        return this.active;
    }

    public float getToastProgress() {
        return 1.0f - (float)this.toastTicks / 1200.0f;
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean isBurningToast() {
        CompoundTag firstTag = this.container.getItem(0).getTag();
        CompoundTag secondTag = this.container.getItem(1).getTag();
        return firstTag != null && firstTag.getBoolean("CookingForBlockheadsToasted") || secondTag != null && secondTag.getBoolean("CookingForBlockheadsToasted");
    }

    private ItemStack toastItem(ItemStack itemStack) {
        SimpleContainer craftingContainer = new SimpleContainer(new ItemStack[]{itemStack});
        List toastRecipes = this.level.getRecipeManager().getRecipesFor(ModRecipes.toasterRecipeType, (Container)craftingContainer, this.level);
        for (RecipeHolder toastRecipe : toastRecipes) {
            ItemStack assembled = ((ToasterRecipe)toastRecipe.value()).assemble((Container)craftingContainer, this.level.registryAccess());
            if (assembled.isEmpty()) continue;
            return assembled;
        }
        if (itemStack.is(Items.BREAD)) {
            return this.toastBread(itemStack);
        }
        return itemStack;
    }

    private ItemStack toastBread(ItemStack itemStack) {
        boolean alreadyToasted;
        CompoundTag tag = itemStack.getTag();
        boolean bl = alreadyToasted = tag != null && tag.getBoolean("CookingForBlockheadsToasted");
        if (alreadyToasted) {
            if (CookingForBlockheadsConfig.getActive().allowVeryToastedBread) {
                ItemStack veryToasted = new ItemStack((ItemLike)Items.CHARCOAL);
                veryToasted.setHoverName((Component)Component.translatable((String)"tooltip.cookingforblockheads.very_toasted"));
                return veryToasted;
            }
            return itemStack;
        }
        ItemStack toasted = itemStack.copy();
        toasted.setHoverName((Component)Component.translatable((String)"tooltip.cookingforblockheads.toasted", (Object[])new Object[]{itemStack.getHoverName()}));
        toasted.getOrCreateTag().putBoolean("CookingForBlockheadsToasted", true);
        return toasted;
    }

    public boolean canToast(ItemStack itemStack) {
        return this.level.getRecipeManager().getRecipeFor(ModRecipes.toasterRecipeType, (Container)new SimpleContainer(new ItemStack[]{itemStack}), this.level).map(it -> true).orElseGet(() -> itemStack.is(Items.BREAD));
    }
}

