/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.client.rendering.BalmModels;
import net.blay09.mods.cookingforblockheads.block.BaseKitchenBlock;
import net.blay09.mods.cookingforblockheads.block.FridgeBlock;
import net.blay09.mods.cookingforblockheads.block.ModBlocks;
import net.blay09.mods.cookingforblockheads.block.SinkBlock;
import net.blay09.mods.cookingforblockheads.block.ToasterBlock;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ModModels {
    public static DeferredObject<BakedModel> milkJarLiquid;
    public static DeferredObject<BakedModel> sinkLiquid;
    public static List<DeferredObject<BakedModel>> ovenDoors;
    public static List<DeferredObject<BakedModel>> ovenDoorHandles;
    public static List<DeferredObject<BakedModel>> ovenDoorsActive;
    public static DeferredObject<BakedModel> fridgeDoor;
    public static DeferredObject<BakedModel> fridgeDoorFlipped;
    public static DeferredObject<BakedModel> fridgeDoorLargeLower;
    public static DeferredObject<BakedModel> fridgeDoorLargeUpper;
    public static DeferredObject<BakedModel> fridgeDoorLargeLowerFlipped;
    public static DeferredObject<BakedModel> fridgeDoorLargeUpperFlipped;
    public static List<DeferredObject<BakedModel>> counterDoors;
    public static List<DeferredObject<BakedModel>> counterDoorsFlipped;
    public static List<DeferredObject<BakedModel>> cabinetDoors;
    public static List<DeferredObject<BakedModel>> cabinetDoorsFlipped;

    public static void initialize(BalmModels models) {
        DyeColor[] colors = DyeColor.values();
        milkJarLiquid = models.loadModel(ModModels.id("block/milk_jar_liquid"));
        sinkLiquid = models.loadModel(ModModels.id("block/sink_liquid"));
        ovenDoors = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        ovenDoorHandles = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        ovenDoorsActive = new ArrayList<DeferredObject<BakedModel>>(colors.length);
        models.loadModel(ModModels.id("block/dyed_oven_door_active"));
        for (DyeColor color : colors) {
            String colorPrefix = color.getSerializedName() + "_";
            Object colorPrefixExceptWhite = color == DyeColor.WHITE ? "" : colorPrefix;
            ovenDoors.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + (String)colorPrefixExceptWhite + "oven_door")));
            ovenDoorsActive.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/" + (String)colorPrefixExceptWhite + "oven_door_active")));
            ovenDoorHandles.add(color.getId(), (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/oven_door_handle")));
        }
        fridgeDoor = models.loadModel(ModModels.id("block/fridge_door"));
        fridgeDoorFlipped = models.loadModel(ModModels.id("block/fridge_door_flipped"));
        fridgeDoorLargeLower = models.loadModel(ModModels.id("block/fridge_large_door_lower"));
        fridgeDoorLargeLowerFlipped = models.loadModel(ModModels.id("block/fridge_large_door_lower_flipped"));
        fridgeDoorLargeUpper = models.loadModel(ModModels.id("block/fridge_large_door_upper"));
        fridgeDoorLargeUpperFlipped = models.loadModel(ModModels.id("block/fridge_large_door_upper_flipped"));
        counterDoors = new ArrayList<DeferredObject<BakedModel>>(colors.length + 1);
        counterDoors.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/counter_door")));
        counterDoorsFlipped = new ArrayList<DeferredObject<BakedModel>>(colors.length + 1);
        counterDoorsFlipped.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/counter_door_flipped")));
        for (DyeColor color : colors) {
            counterDoors.add(color.getId() + 1, (DeferredObject<BakedModel>)models.retexture(ModModels.id("block/counter_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
            counterDoorsFlipped.add(color.getId() + 1, (DeferredObject<BakedModel>)models.retexture(ModModels.id("block/counter_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
        }
        cabinetDoors = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoors.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/cabinet_door")));
        cabinetDoorsFlipped = Lists.newArrayListWithCapacity((int)(colors.length + 1));
        cabinetDoorsFlipped.add(0, (DeferredObject<BakedModel>)models.loadModel(ModModels.id("block/cabinet_door_flipped")));
        for (DyeColor color : colors) {
            cabinetDoors.add(color.getId() + 1, (DeferredObject<BakedModel>)models.retexture(ModModels.id("block/cabinet_door"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
            cabinetDoorsFlipped.add(color.getId() + 1, (DeferredObject<BakedModel>)models.retexture(ModModels.id("block/cabinet_door_flipped"), ModModels.replaceTexture(ModModels.getColoredTerracottaTexture(color))));
        }
        ResourceLocation sinkModel = ModModels.id("block/sink");
        ResourceLocation sinkFlippedModel = ModModels.id("block/sink_flipped");
        models.overrideModel(() -> ModBlocks.sink, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/sink"), it -> (Boolean)it.getValue((Property)SinkBlock.FLIPPED) != false ? sinkFlippedModel : sinkModel, it -> {
            if (((Boolean)it.getValue((Property)SinkBlock.HAS_COLOR)).booleanValue()) {
                return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((DyeColor)it.getValue((Property)SinkBlock.COLOR)));
            }
            return Collections.emptyMap();
        }, ModModels::lowerableFacingTransforms)).get());
        ResourceLocation toasterModel = ModModels.id("block/toaster");
        ResourceLocation toasterActiveModel = ModModels.id("block/toaster_active");
        models.overrideModel(() -> ModBlocks.toaster, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/toaster"), it -> (Boolean)it.getValue((Property)ToasterBlock.ACTIVE) != false ? toasterActiveModel : toasterModel, null, ModModels::lowerableFacingTransforms)).get());
        ResourceLocation fridgeSmallModel = ModModels.id("block/fridge");
        ResourceLocation fridgeLargeLowerModel = ModModels.id("block/fridge_large_lower");
        ResourceLocation fridgeLargeUpperModel = ModModels.id("block/fridge_large_upper");
        models.overrideModel(() -> ModBlocks.fridge, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id("block/fridge"), it -> {
            FridgeBlock.FridgeModelType fridgeModelType = (FridgeBlock.FridgeModelType)((Object)((Object)it.getValue(FridgeBlock.MODEL_TYPE)));
            return switch (fridgeModelType) {
                case FridgeBlock.FridgeModelType.LARGE_LOWER -> fridgeLargeLowerModel;
                case FridgeBlock.FridgeModelType.LARGE_UPPER -> fridgeLargeUpperModel;
                default -> fridgeSmallModel;
            };
        }, null, ModModels::lowerableFacingTransforms)).get());
        models.overrideModel(() -> ModBlocks.cuttingBoard, () -> ModModels.createLowerableFacingModel("block/cutting_board").get());
        models.overrideModel(() -> ModBlocks.fruitBasket, () -> ModModels.createLowerableFacingModel("block/fruit_basket").get());
        models.overrideModel(() -> ModBlocks.milkJar, () -> ModModels.createLowerableFacingModel("block/milk_jar", List.of(RenderType.cutout())).get());
        models.overrideModel(() -> ModBlocks.cowJar, () -> ModModels.createLowerableFacingModel("block/milk_jar", List.of(RenderType.cutout())).get());
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.cookingTable, "block/cooking_table");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.counter, "block/counter");
        ModModels.registerColoredKitchenBlock(BalmClient.getModels(), () -> ModBlocks.cabinet, "block/cabinet");
    }

    private static DeferredObject<BakedModel> createLowerableFacingModel(String modelPath) {
        return ModModels.createLowerableFacingModel(modelPath, Collections.emptyList());
    }

    private static DeferredObject<BakedModel> createLowerableFacingModel(String modelPath, List<RenderType> renderTypes) {
        return BalmClient.getModels().loadDynamicModel(ModModels.id(modelPath), null, null, ModModels::lowerableFacingTransforms, renderTypes);
    }

    private static void registerColoredKitchenBlock(BalmModels models, Supplier<Block> blockSupplier, String modelPath) {
        models.overrideModel(blockSupplier, () -> ((DeferredObject)models.loadDynamicModel(ModModels.id(modelPath), null, it -> {
            if (((Boolean)it.getValue((Property)BaseKitchenBlock.HAS_COLOR)).booleanValue()) {
                return ModModels.replaceTexture(ModModels.getColoredTerracottaTexture((DyeColor)it.getValue(BaseKitchenBlock.COLOR)));
            }
            return Collections.emptyMap();
        }, ModModels::lowerableFacingTransforms)).get());
    }

    private static ResourceLocation id(String path) {
        return new ResourceLocation("cookingforblockheads", path);
    }

    private static ImmutableMap<String, String> replaceTexture(String texturePath) {
        return ImmutableMap.builder().put((Object)"texture", (Object)texturePath).put((Object)"particle", (Object)texturePath).build();
    }

    private static String getColoredTerracottaTexture(DyeColor color) {
        return "minecraft:block/" + color.name().toLowerCase(Locale.ENGLISH) + "_terracotta";
    }

    private static void lowerableFacingTransforms(BlockState state, Matrix4f transform) {
        if (state.hasProperty((Property)BaseKitchenBlock.LOWERED) && ((Boolean)state.getValue((Property)BaseKitchenBlock.LOWERED)).booleanValue()) {
            transform.translate((Vector3fc)new Vector3f(0.0f, -0.05f, 0.0f));
        }
        if (state.hasProperty((Property)BaseKitchenBlock.FACING)) {
            float angle = ((Direction)state.getValue((Property)BaseKitchenBlock.FACING)).toYRot();
            transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(180.0f - angle));
        }
    }
}

