/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.function.Consumer;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.block.entity.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.ToasterBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CookingForBlockheadsWailaUtils {
    public static final ResourceLocation MILK_JAR_UID = new ResourceLocation("cookingforblockheads", "milk_jar");
    public static final ResourceLocation TOASTER_UID = new ResourceLocation("cookingforblockheads", "toaster");
    public static final ResourceLocation OVEN_UID = new ResourceLocation("cookingforblockheads", "oven");
    public static final ResourceLocation FRIDGE_UID = new ResourceLocation("cookingforblockheads", "fridge");
    public static final ResourceLocation SINK_UID = new ResourceLocation("cookingforblockheads", "sink");

    public static void appendMilkJarTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        CowJarBlockEntity cowJar;
        if (blockEntity instanceof CowJarBlockEntity && (cowJar = (CowJarBlockEntity)blockEntity).getCustomName() != null) {
            tooltipConsumer.accept(cowJar.getCustomName());
        }
        if (blockEntity instanceof MilkJarBlockEntity) {
            MilkJarBlockEntity milkJar = (MilkJarBlockEntity)blockEntity;
            FluidTank fluidTank = milkJar.getFluidTank();
            tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.milk_stored", (Object[])new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
        }
    }

    public static void appendToasterTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        ToasterBlockEntity toaster;
        if (blockEntity instanceof ToasterBlockEntity && (toaster = (ToasterBlockEntity)blockEntity).isActive()) {
            tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.toast_progress", (Object[])new Object[]{(int)(toaster.getToastProgress() * 100.0f)}));
        }
    }

    public static void appendOvenTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        OvenBlockEntity oven;
        if (blockEntity instanceof OvenBlockEntity && (oven = (OvenBlockEntity)blockEntity).hasPowerUpgrade()) {
            tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.heating_unit"));
        }
    }

    public static void appendFridgeTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            if (fridge.hasIceUpgrade()) {
                tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.ice_unit"));
            }
            if (fridge.hasPreservationUpgrade()) {
                tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.preservation_chamber"));
            }
        }
    }

    public static void appendSinkTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        if (blockEntity instanceof SinkBlockEntity) {
            SinkBlockEntity sink = (SinkBlockEntity)blockEntity;
            if (CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                FluidTank fluidTank = sink.getFluidTank();
                tooltipConsumer.accept((Component)Component.translatable((String)"waila.cookingforblockheads.water_stored", (Object[])new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
            }
        }
    }

    private CookingForBlockheadsWailaUtils() {
    }

    @FunctionalInterface
    public static interface TooltipAppender {
        public void appendTooltip(BlockEntity var1, Player var2, Consumer<Component> var3);
    }
}

