/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.crafting;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.cookingforblockheads.tag.ModItemTags;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public record RecipeWithStatus(ResourceLocation recipeId, ItemStack resultItem, List<Ingredient> missingIngredients, int missingIngredientsMask, NonNullList<ItemStack> lockedInputs) {
    public RecipeHolder<?> recipe(Player player) {
        return player.level().getRecipeManager().byKey(this.recipeId).orElse(null);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeResourceLocation(this.recipeId);
        buf.writeItem(this.resultItem);
        buf.writeInt(this.missingIngredientsMask);
        buf.writeInt(this.missingIngredients.size());
        for (Ingredient ingredient : this.missingIngredients) {
            ingredient.toNetwork(buf);
        }
        if (this.lockedInputs != null) {
            buf.writeInt(this.lockedInputs.size());
            for (ItemStack lockedInput : this.lockedInputs) {
                buf.writeItem(lockedInput);
            }
        } else {
            buf.writeInt(0);
        }
    }

    public static RecipeWithStatus fromNetwork(FriendlyByteBuf buf) {
        ResourceLocation recipeId = buf.readResourceLocation();
        ItemStack resultItem = buf.readItem();
        int missingIngredientsMask = buf.readInt();
        int missingIngredientCount = buf.readInt();
        ArrayList<Ingredient> missingIngredients = new ArrayList<Ingredient>(missingIngredientCount);
        for (int j = 0; j < missingIngredientCount; ++j) {
            missingIngredients.add(Ingredient.fromNetwork((FriendlyByteBuf)buf));
        }
        int lockedInputCount = buf.readInt();
        NonNullList lockedInputs = NonNullList.withSize((int)lockedInputCount, (Object)ItemStack.EMPTY);
        for (int j = 0; j < lockedInputCount; ++j) {
            lockedInputs.set(j, (Object)buf.readItem());
        }
        return new RecipeWithStatus(recipeId, resultItem, missingIngredients, missingIngredientsMask, (NonNullList<ItemStack>)lockedInputs);
    }

    public static RecipeWithStatus best(@Nullable RecipeWithStatus first, @Nullable RecipeWithStatus second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first.missingIngredients.size() < second.missingIngredients.size()) {
            return first;
        }
        if (second.missingIngredients.size() < first.missingIngredients.size()) {
            return second;
        }
        return first;
    }

    public boolean canCraft() {
        return this.missingIngredients.isEmpty();
    }

    public boolean isMissingUtensils() {
        return this.missingIngredients.stream().anyMatch(RecipeWithStatus::isUtensil);
    }

    private static boolean isUtensil(Ingredient ingredient) {
        for (ItemStack itemStack : ingredient.getItems()) {
            if (!itemStack.is(ModItemTags.UTENSILS)) continue;
            return true;
        }
        return false;
    }
}

