/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.item;

import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.ModMenus;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemRecipeBook
extends Item {
    private final RecipeBookEdition edition;

    public ItemRecipeBook(RecipeBookEdition edition) {
        super(new Item.Properties().stacksTo(1));
        this.edition = edition;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            final ItemStack itemStack = player.getItemInHand(hand);
            Balm.getNetworking().openGui(player, (MenuProvider)new BalmMenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)("container.cookingforblockheads." + ItemRecipeBook.this.edition.getName()));
                }

                public AbstractContainerMenu createMenu(int i, Inventory playerInventory, Player playerEntity) {
                    return new KitchenMenu(ItemRecipeBook.this.edition.getMenuTypeSupplier().get(), i, playerEntity, new KitchenImpl(itemStack));
                }

                public void writeScreenOpeningData(ServerPlayer player, FriendlyByteBuf buf) {
                    buf.writeItem(itemStack);
                }
            });
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(itemStack, level, tooltip, flag);
        String editionName = this.edition.getName();
        tooltip.add((Component)Component.translatable((String)("tooltip.cookingforblockheads." + editionName)).withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)("tooltip.cookingforblockheads." + editionName + ".description")).withStyle(ChatFormatting.GRAY));
    }

    public static enum RecipeBookEdition {
        NO_FILTER("no_filter_edition", () -> (MenuType)ModMenus.noFilterBook.get()),
        RECIPE("recipe_book", () -> (MenuType)ModMenus.recipeBook.get()),
        CRAFTING("crafting_book", () -> (MenuType)ModMenus.craftingBook.get());

        private final String name;
        private final Supplier<MenuType<KitchenMenu>> containerTypeSupplier;

        private RecipeBookEdition(String name, Supplier<MenuType<KitchenMenu>> containerTypeSupplier) {
            this.name = name;
            this.containerTypeSupplier = containerTypeSupplier;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<MenuType<KitchenMenu>> getMenuTypeSupplier() {
            return this.containerTypeSupplier;
        }
    }
}

