/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.menu;

import java.util.Objects;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.menu.BalmMenus;
import net.blay09.mods.cookingforblockheads.block.entity.CounterBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.FruitBasketBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.block.entity.SpiceRackBlockEntity;
import net.blay09.mods.cookingforblockheads.crafting.KitchenImpl;
import net.blay09.mods.cookingforblockheads.menu.CounterMenu;
import net.blay09.mods.cookingforblockheads.menu.FridgeMenu;
import net.blay09.mods.cookingforblockheads.menu.FruitBasketMenu;
import net.blay09.mods.cookingforblockheads.menu.KitchenMenu;
import net.blay09.mods.cookingforblockheads.menu.OvenMenu;
import net.blay09.mods.cookingforblockheads.menu.SpiceRackMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class ModMenus {
    public static DeferredObject<MenuType<CounterMenu>> counter;
    public static DeferredObject<MenuType<FridgeMenu>> fridge;
    public static DeferredObject<MenuType<FruitBasketMenu>> fruitBasket;
    public static DeferredObject<MenuType<OvenMenu>> oven;
    public static DeferredObject<MenuType<SpiceRackMenu>> spiceRack;
    public static DeferredObject<MenuType<KitchenMenu>> recipeBook;
    public static DeferredObject<MenuType<KitchenMenu>> cookingTable;
    public static DeferredObject<MenuType<KitchenMenu>> noFilterBook;
    public static DeferredObject<MenuType<KitchenMenu>> craftingBook;

    public static void initialize(BalmMenus menus) {
        counter = menus.registerMenu(ModMenus.id("counter"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity tileEntity = inv.player.level().getBlockEntity(pos);
            return new CounterMenu(windowId, inv, (CounterBlockEntity)Objects.requireNonNull(tileEntity));
        });
        fridge = menus.registerMenu(ModMenus.id("fridge"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity tileEntity = inv.player.level().getBlockEntity(pos);
            return new FridgeMenu(windowId, inv, (FridgeBlockEntity)Objects.requireNonNull(tileEntity));
        });
        fruitBasket = menus.registerMenu(ModMenus.id("fruit_basket"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity tileEntity = inv.player.level().getBlockEntity(pos);
            return new FruitBasketMenu(windowId, inv, (FruitBasketBlockEntity)Objects.requireNonNull(tileEntity));
        });
        oven = menus.registerMenu(ModMenus.id("oven"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity tileEntity = inv.player.level().getBlockEntity(pos);
            return new OvenMenu(windowId, inv, (OvenBlockEntity)Objects.requireNonNull(tileEntity));
        });
        spiceRack = menus.registerMenu(ModMenus.id("spice_rack"), (windowId, inv, data) -> {
            BlockPos pos = data.readBlockPos();
            BlockEntity tileEntity = inv.player.level().getBlockEntity(pos);
            return new SpiceRackMenu(windowId, inv, (SpiceRackBlockEntity)Objects.requireNonNull(tileEntity));
        });
        cookingTable = menus.registerMenu(ModMenus.id("cooking_table"), (windowId, inv, data) -> {
            Level level = inv.player.level();
            BlockPos pos = data.readBlockPos();
            KitchenImpl kitchen = new KitchenImpl(level, pos);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)cookingTable.get()), windowId, inv.player, kitchen);
        });
        noFilterBook = menus.registerMenu(ModMenus.id("no_filter_book"), (windowId, inv, data) -> {
            ItemStack itemStack = data.readItem();
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)noFilterBook.get()), windowId, inv.player, kitchen);
        });
        recipeBook = menus.registerMenu(ModMenus.id("recipe_book"), (windowId, inv, data) -> {
            ItemStack itemStack = data.readItem();
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)recipeBook.get()), windowId, inv.player, kitchen);
        });
        craftingBook = menus.registerMenu(ModMenus.id("crafting_book"), (windowId, inv, data) -> {
            ItemStack itemStack = data.readItem();
            KitchenImpl kitchen = new KitchenImpl(itemStack);
            return new KitchenMenu((MenuType<KitchenMenu>)((MenuType)craftingBook.get()), windowId, inv.player, kitchen);
        });
    }

    @NotNull
    private static ResourceLocation id(String name) {
        return new ResourceLocation("cookingforblockheads", name);
    }
}

