/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.blay09.mods.cookingforblockheads.recipe.ModRecipes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class ToasterRecipe
implements Recipe<Container> {
    private final Ingredient ingredient;
    private final ItemStack resultItem;

    public ToasterRecipe(Ingredient ingredient, ItemStack resultItem) {
        this.ingredient = ingredient;
        this.resultItem = resultItem;
    }

    public boolean matches(Container container, Level level) {
        for (int i = 0; i < container.getContainerSize(); ++i) {
            ItemStack slotStack = container.getItem(i);
            if (!this.ingredient.test(slotStack)) continue;
            return true;
        }
        return false;
    }

    public ItemStack assemble(Container container, RegistryAccess registryAccess) {
        return this.resultItem.copy();
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return this.resultItem;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.toasterRecipeSerializer;
    }

    public RecipeType<?> getType() {
        return ModRecipes.toasterRecipeType;
    }

    static class Serializer
    implements RecipeSerializer<ToasterRecipe> {
        private static final Codec<ItemStack> RESULT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.holderByNameCodec().fieldOf("item").orElse((Object)BuiltInRegistries.ITEM.wrapAsHolder((Object)Items.AIR)).forGetter(ItemStack::getItemHolder), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)"count", (Object)1).forGetter(ItemStack::getCount), (App)CompoundTag.CODEC.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.getTag()))).apply((Applicative)instance, ItemStack::new));
        private static final Codec<ToasterRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)RESULT_CODEC.fieldOf("result").forGetter(recipe -> recipe.resultItem)).apply((Applicative)instance, ToasterRecipe::new));

        Serializer() {
        }

        public Codec<ToasterRecipe> codec() {
            return CODEC;
        }

        public ToasterRecipe fromNetwork(FriendlyByteBuf buf) {
            Ingredient ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buf);
            ItemStack resultItem = buf.readItem();
            return new ToasterRecipe(ingredient, resultItem);
        }

        public void toNetwork(FriendlyByteBuf buf, ToasterRecipe recipe) {
            recipe.ingredient.toNetwork(buf);
            buf.writeItem(recipe.resultItem);
        }
    }
}

