/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.behaviors.GenericSlotCapacities;
import appeng.api.client.StorageCellModels;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.AEKeyTypes;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.upgrades.Upgrades;
import appeng.capabilities.AppEngCapabilities;
import appeng.core.definitions.AEItems;
import appeng.core.localization.GuiText;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.common.MEStorageMenu;
import appeng.parts.automation.StackWorldBehaviors;
import java.util.function.Function;
import me.ramidzkh.mekae2.AMItems;
import me.ramidzkh.mekae2.AMMenus;
import me.ramidzkh.mekae2.AppliedMekanisticsClient;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.ChemicalContainerItemStrategy;
import me.ramidzkh.mekae2.ae2.ChemicalP2PTunnelPart;
import me.ramidzkh.mekae2.ae2.GenericStackChemicalStorage;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.ae2.stack.MekanismExternalStorageStrategy;
import me.ramidzkh.mekae2.ae2.stack.MekanismStackExportStrategy;
import me.ramidzkh.mekae2.ae2.stack.MekanismStackImportStrategy;
import me.ramidzkh.mekae2.data.MekAE2DataGenerators;
import me.ramidzkh.mekae2.qio.QioSupport;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredItem;

@Mod(value="appmek")
public class AppliedMekanistics {
    public static final String ID = "appmek";

    public static ResourceLocation id(String path) {
        return new ResourceLocation(ID, path);
    }

    public AppliedMekanistics(IEventBus bus) {
        AMItems.initialize(bus);
        AMMenus.initialize(bus);
        bus.addListener(MekAE2DataGenerators::onGatherData);
        bus.addListener(event -> {
            if (!event.getRegistryKey().equals(Registries.BLOCK)) {
                return;
            }
            AEKeyTypes.register((AEKeyType)MekanismKeyType.TYPE);
        });
        StackWorldBehaviors.registerImportStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismStackImportStrategy::new);
        StackWorldBehaviors.registerExportStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismStackExportStrategy::new);
        StackWorldBehaviors.registerExternalStorageStrategy((AEKeyType)MekanismKeyType.TYPE, MekanismExternalStorageStrategy::new);
        ContainerItemStrategy.register((AEKeyType)MekanismKeyType.TYPE, MekanismKey.class, (ContainerItemStrategy)new ChemicalContainerItemStrategy());
        GenericSlotCapacities.register((AEKeyType)MekanismKeyType.TYPE, (Long)((Long)GenericSlotCapacities.getMap().get(AEKeyType.fluids())));
        bus.addListener(EventPriority.LOWEST, this::registerGenericAdapters);
        bus.addListener(QioSupport::onBlockEntityCapability);
        bus.addListener(this::registerPartCapabilities);
        bus.addListener(event -> {
            event.enqueueWork(this::initializeModels);
            event.enqueueWork(this::initializeUpgrades);
            event.enqueueWork(this::initializeAttunement);
        });
        if (FMLEnvironment.dist == Dist.CLIENT) {
            AppliedMekanisticsClient.initialize(bus);
        }
    }

    private void registerPartCapabilities(RegisterPartCapabilitiesEvent event) {
        event.register(MekCapabilities.GAS.block(), (part, context) -> part.getGasHandler(), ChemicalP2PTunnelPart.class);
        event.register(MekCapabilities.INFUSION.block(), (part, context) -> part.getInfuseHandler(), ChemicalP2PTunnelPart.class);
        event.register(MekCapabilities.PIGMENT.block(), (part, context) -> part.getPigmentHandler(), ChemicalP2PTunnelPart.class);
        event.register(MekCapabilities.SLURRY.block(), (part, context) -> part.getSlurryHandler(), ChemicalP2PTunnelPart.class);
    }

    private void registerGenericAdapters(RegisterCapabilitiesEvent event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!event.isBlockRegistered(AppEngCapabilities.GENERIC_INTERNAL_INV, block)) continue;
            AppliedMekanistics.registerGenericInvAdapter(event, block, MekCapabilities.GAS.block(), GenericStackChemicalStorage.OfGas::new);
            AppliedMekanistics.registerGenericInvAdapter(event, block, MekCapabilities.INFUSION.block(), GenericStackChemicalStorage.OfInfusion::new);
            AppliedMekanistics.registerGenericInvAdapter(event, block, MekCapabilities.PIGMENT.block(), GenericStackChemicalStorage.OfPigment::new);
            AppliedMekanistics.registerGenericInvAdapter(event, block, MekCapabilities.SLURRY.block(), GenericStackChemicalStorage.OfSlurry::new);
        }
    }

    private void initializeModels() {
        StorageCells.addCellGuiHandler((ICellGuiHandler)new ICellGuiHandler(){

            public boolean isSpecializedFor(ItemStack cell) {
                IBasicCellItem basicCellItem;
                Item item = cell.getItem();
                return item instanceof IBasicCellItem && (basicCellItem = (IBasicCellItem)item).getKeyType() == MekanismKeyType.TYPE;
            }

            public void openChestGui(Player player, IChestOrDrive chest, ICellHandler cellHandler, ItemStack cell) {
                MenuOpener.open((MenuType)MEStorageMenu.TYPE, (Player)player, (MenuHostLocator)MenuLocators.forBlockEntity((BlockEntity)((BlockEntity)chest)));
            }
        });
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            DeferredItem<Item> cell = AMItems.get(tier);
            DeferredItem<Item> portable = AMItems.getPortableCell(tier);
            this.registerCell(() -> cell.get(), () -> portable.get(), cell.getId().getPath());
        }
    }

    private void registerCell(ItemLike cell, ItemLike portableCell, String path) {
        StorageCellModels.registerModel((ItemLike)cell, (ResourceLocation)AppliedMekanistics.id("block/drive/cells/" + path));
        StorageCellModels.registerModel((ItemLike)portableCell, (ResourceLocation)AppliedMekanistics.id("block/drive/cells/" + path));
    }

    private void initializeUpgrades() {
        String storageCellGroup = GuiText.StorageCells.getTranslationKey();
        String portableStorageCellGroup = GuiText.PortableCells.getTranslationKey();
        for (AMItems.Tier tier : AMItems.Tier.values()) {
            DeferredItem<Item> cell = AMItems.get(tier);
            DeferredItem<Item> portableCell = AMItems.getPortableCell(tier);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.EQUAL_DISTRIBUTION_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.VOID_CARD, () -> cell.get(), (int)1, (String)storageCellGroup);
            Upgrades.add((ItemLike)AEItems.INVERTER_CARD, () -> portableCell.get(), (int)1, (String)portableStorageCellGroup);
            Upgrades.add((ItemLike)AEItems.ENERGY_CARD, () -> portableCell.get(), (int)2, (String)portableStorageCellGroup);
        }
    }

    private void initializeAttunement() {
        P2PTunnelAttunement.registerAttunementTag(() -> AMItems.CHEMICAL_P2P_TUNNEL.get());
    }

    private static <T> void registerGenericInvAdapter(RegisterCapabilitiesEvent event, Block block, BlockCapability<T, Direction> capability, Function<GenericInternalInventory, T> adapter) {
        event.registerBlock(capability, (level, pos, state, blockEntity, context) -> {
            GenericInternalInventory genericInv = (GenericInternalInventory)level.getCapability(AppEngCapabilities.GENERIC_INTERNAL_INV, pos, state, blockEntity, context);
            if (genericInv != null) {
                return adapter.apply(genericInv);
            }
            return null;
        }, new Block[]{block});
    }
}

