/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.ContainerItemStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class ChemicalContainerItemStrategy
implements ContainerItemStrategy<MekanismKey, ItemStack> {
    @Nullable
    public GenericStack getContainedStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return null;
        }
        for (MekCapabilities.CapSet<?> capability : MekCapabilities.HANDLERS) {
            ChemicalStack chemical;
            MekanismKey key;
            IChemicalHandler handler = (IChemicalHandler)stack.getCapability(capability.item());
            if (handler == null || (key = MekanismKey.of(chemical = handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE))) == null) continue;
            return new GenericStack((AEKey)key, chemical.getAmount());
        }
        return null;
    }

    @Nullable
    public ItemStack findCarriedContext(Player player, AbstractContainerMenu menu) {
        ItemStack carried = menu.getCarried();
        for (MekCapabilities.CapSet<?> capability : MekCapabilities.HANDLERS) {
            if (carried.getCapability(capability.item()) == null) continue;
            return carried;
        }
        return null;
    }

    @Nullable
    public ItemStack findPlayerSlotContext(Player player, int slot) {
        ItemStack carried = player.getInventory().getItem(slot);
        for (MekCapabilities.CapSet<?> capability : MekCapabilities.HANDLERS) {
            if (carried.getCapability(capability.item()) == null) continue;
            return carried;
        }
        return null;
    }

    public long extract(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = what.withAmount(amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            IGasHandler handler = (IGasHandler)context.getCapability(MekCapabilities.GAS.item());
            if (handler != null) {
                return ((GasStack)handler.extractChemical((ChemicalStack)gas, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            IInfusionHandler handler = (IInfusionHandler)context.getCapability(MekCapabilities.INFUSION.item());
            if (handler != null) {
                return ((InfusionStack)handler.extractChemical((ChemicalStack)infusion, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            IPigmentHandler handler = (IPigmentHandler)context.getCapability(MekCapabilities.PIGMENT.item());
            if (handler != null) {
                return ((PigmentStack)handler.extractChemical((ChemicalStack)pigment, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            ISlurryHandler handler = (ISlurryHandler)context.getCapability(MekCapabilities.SLURRY.item());
            if (handler != null) {
                return ((SlurryStack)handler.extractChemical((ChemicalStack)slurry, action)).getAmount();
            }
            return 0L;
        }
        throw new UnsupportedOperationException();
    }

    public long insert(ItemStack context, MekanismKey what, long amount, Actionable mode) {
        ChemicalStack<?> stack = what.withAmount(amount);
        Action action = Action.fromFluidAction((IFluidHandler.FluidAction)mode.getFluidAction());
        if (stack instanceof GasStack) {
            GasStack gas = (GasStack)stack;
            IGasHandler handler = (IGasHandler)context.getCapability(MekCapabilities.GAS.item());
            if (handler != null) {
                return amount - ((GasStack)handler.insertChemical((ChemicalStack)gas, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof InfusionStack) {
            InfusionStack infusion = (InfusionStack)stack;
            IInfusionHandler handler = (IInfusionHandler)context.getCapability(MekCapabilities.INFUSION.item());
            if (handler != null) {
                return amount - ((InfusionStack)handler.insertChemical((ChemicalStack)infusion, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof PigmentStack) {
            PigmentStack pigment = (PigmentStack)stack;
            IPigmentHandler handler = (IPigmentHandler)context.getCapability(MekCapabilities.PIGMENT.item());
            if (handler != null) {
                return amount - ((PigmentStack)handler.insertChemical((ChemicalStack)pigment, action)).getAmount();
            }
            return 0L;
        }
        if (stack instanceof SlurryStack) {
            SlurryStack slurry = (SlurryStack)stack;
            ISlurryHandler handler = (ISlurryHandler)context.getCapability(MekCapabilities.SLURRY.item());
            if (handler != null) {
                return amount - ((SlurryStack)handler.insertChemical((ChemicalStack)slurry, action)).getAmount();
            }
            return 0L;
        }
        throw new UnsupportedOperationException();
    }

    public void playFillSound(Player player, MekanismKey what) {
        player.playNotifySound(SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public void playEmptySound(Player player, MekanismKey what) {
        player.playNotifySound(SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    @Nullable
    public GenericStack getExtractableContent(ItemStack context) {
        return this.getContainedStack(context);
    }
}

