/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import me.ramidzkh.mekae2.AppliedMekanistics;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.ae2.MultipleCapabilityP2PTunnelPart;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class ChemicalP2PTunnelPart
extends MultipleCapabilityP2PTunnelPart<ChemicalP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels(AppliedMekanistics.id("part/chemical_p2p_tunnel"));

    public ChemicalP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, self -> List.of(new MultipleCapabilityP2PTunnelPart.CapabilitySet<IGasHandler>(MekCapabilities.GAS.block(), new InputChemicalHandler.OfGas((ChemicalP2PTunnelPart)((Object)self)), new OutputChemicalHandler.OfGas((ChemicalP2PTunnelPart)((Object)self)), NullChemicalHandler.GAS), new MultipleCapabilityP2PTunnelPart.CapabilitySet<IInfusionHandler>(MekCapabilities.INFUSION.block(), new InputChemicalHandler.OfInfusion((ChemicalP2PTunnelPart)((Object)self)), new OutputChemicalHandler.OfInfusion((ChemicalP2PTunnelPart)((Object)self)), NullChemicalHandler.INFUSION), new MultipleCapabilityP2PTunnelPart.CapabilitySet<IPigmentHandler>(MekCapabilities.PIGMENT.block(), new InputChemicalHandler.OfPigment((ChemicalP2PTunnelPart)((Object)self)), new OutputChemicalHandler.OfPigment((ChemicalP2PTunnelPart)((Object)self)), NullChemicalHandler.PIGMENT), new MultipleCapabilityP2PTunnelPart.CapabilitySet<ISlurryHandler>(MekCapabilities.SLURRY.block(), new InputChemicalHandler.OfSlurry((ChemicalP2PTunnelPart)((Object)self)), new OutputChemicalHandler.OfSlurry((ChemicalP2PTunnelPart)((Object)self)), NullChemicalHandler.SLURRY)));
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    protected float getPowerDrainPerTick() {
        return 4.0f;
    }

    public IGasHandler getGasHandler() {
        return this.getCapability(MekCapabilities.GAS.block());
    }

    public IInfusionHandler getInfuseHandler() {
        return this.getCapability(MekCapabilities.INFUSION.block());
    }

    public IPigmentHandler getPigmentHandler() {
        return this.getCapability(MekCapabilities.PIGMENT.block());
    }

    public ISlurryHandler getSlurryHandler() {
        return this.getCapability(MekCapabilities.SLURRY.block());
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class InputChemicalHandler<C extends Chemical<C>, S extends ChemicalStack<C>, H extends IChemicalHandler<C, S>>
    implements IChemicalHandler<C, S> {
        private final ChemicalP2PTunnelPart part;
        private final BlockCapability<H, Direction> capability;

        protected InputChemicalHandler(ChemicalP2PTunnelPart part, BlockCapability<H, Direction> capability) {
            this.part = part;
            this.capability = capability;
        }

        public int getTanks() {
            return 1;
        }

        public S getChemicalInTank(int tank) {
            return (S)this.getEmptyStack();
        }

        public void setChemicalInTank(int tank, S stack) {
            throw new UnsupportedOperationException();
        }

        public long getTankCapacity(int tank) {
            return Long.MAX_VALUE;
        }

        public boolean isValid(int tank, S stack) {
            return true;
        }

        public S insertChemical(int tank, S stack, Action action) {
            long total = 0L;
            int outputTunnels = this.part.getOutputs().size();
            long amount = stack.getAmount();
            if (outputTunnels == 0 || amount == 0L) {
                return stack;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (ChemicalP2PTunnelPart target : this.part.getOutputs()) {
                MultipleCapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability(this.capability);
                try {
                    IChemicalHandler output = (IChemicalHandler)capabilityGuard.get();
                    long toSend = amountPerOutput + overflow;
                    overflow = output.insertChemical(ChemicalBridge.withAmount(stack, toSend), action).getAmount();
                    total += toSend - overflow;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            if (action == Action.EXECUTE) {
                this.part.queueTunnelDrain(PowerUnits.AE, (double)total / (double)MekanismKeyType.TYPE.getAmountPerOperation());
            }
            return ChemicalBridge.withAmount(stack, stack.getAmount() - total);
        }

        public S extractChemical(int tank, long maxAmount, Action action) {
            return (S)this.getEmptyStack();
        }

        private static final class OfSlurry
        extends InputChemicalHandler<Slurry, SlurryStack, ISlurryHandler>
        implements ISlurryHandler {
            private OfSlurry(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.SLURRY.block());
            }
        }

        private static final class OfPigment
        extends InputChemicalHandler<Pigment, PigmentStack, IPigmentHandler>
        implements IPigmentHandler {
            private OfPigment(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.PIGMENT.block());
            }
        }

        private static final class OfInfusion
        extends InputChemicalHandler<InfuseType, InfusionStack, IInfusionHandler>
        implements IInfusionHandler {
            private OfInfusion(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.INFUSION.block());
            }
        }

        private static final class OfGas
        extends InputChemicalHandler<Gas, GasStack, IGasHandler>
        implements IGasHandler {
            private OfGas(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.GAS.block());
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class OutputChemicalHandler<C extends Chemical<C>, S extends ChemicalStack<C>, H extends IChemicalHandler<C, S>>
    implements IChemicalHandler<C, S> {
        private final ChemicalP2PTunnelPart part;
        private final BlockCapability<H, Direction> capability;

        private OutputChemicalHandler(ChemicalP2PTunnelPart part, BlockCapability<H, Direction> capability) {
            this.part = part;
            this.capability = capability;
        }

        public int getTanks() {
            try (MultipleCapabilityP2PTunnelPart.CapabilityGuard input = this.part.getInputCapability(this.capability);){
                int n = ((IChemicalHandler)input.get()).getTanks();
                return n;
            }
        }

        public S getChemicalInTank(int tank) {
            try (MultipleCapabilityP2PTunnelPart.CapabilityGuard input = this.part.getInputCapability(this.capability);){
                ChemicalStack chemicalStack = ((IChemicalHandler)input.get()).getChemicalInTank(tank);
                return (S)chemicalStack;
            }
        }

        public void setChemicalInTank(int tank, S stack) {
            throw new UnsupportedOperationException();
        }

        public long getTankCapacity(int tank) {
            try (MultipleCapabilityP2PTunnelPart.CapabilityGuard input = this.part.getInputCapability(this.capability);){
                long l = ((IChemicalHandler)input.get()).getTankCapacity(tank);
                return l;
            }
        }

        public boolean isValid(int tank, S stack) {
            try (MultipleCapabilityP2PTunnelPart.CapabilityGuard input = this.part.getInputCapability(this.capability);){
                boolean bl = ((IChemicalHandler)input.get()).isValid(tank, stack);
                return bl;
            }
        }

        public S insertChemical(int tank, S stack, Action action) {
            return stack;
        }

        public S extractChemical(int tank, long maxAmount, Action action) {
            try (MultipleCapabilityP2PTunnelPart.CapabilityGuard input = this.part.getInputCapability(this.capability);){
                ChemicalStack result = ((IChemicalHandler)input.get()).extractChemical(tank, maxAmount, action);
                if (action.execute()) {
                    this.part.queueTunnelDrain(PowerUnits.AE, (float)result.getAmount() / (float)MekanismKeyType.TYPE.getAmountPerOperation());
                }
                ChemicalStack chemicalStack = result;
                return (S)chemicalStack;
            }
        }

        private static final class OfSlurry
        extends OutputChemicalHandler<Slurry, SlurryStack, ISlurryHandler>
        implements ISlurryHandler {
            private OfSlurry(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.SLURRY.block());
            }
        }

        private static final class OfPigment
        extends OutputChemicalHandler<Pigment, PigmentStack, IPigmentHandler>
        implements IPigmentHandler {
            private OfPigment(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.PIGMENT.block());
            }
        }

        private static final class OfInfusion
        extends OutputChemicalHandler<InfuseType, InfusionStack, IInfusionHandler>
        implements IInfusionHandler {
            private OfInfusion(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.INFUSION.block());
            }
        }

        private static final class OfGas
        extends OutputChemicalHandler<Gas, GasStack, IGasHandler>
        implements IGasHandler {
            private OfGas(ChemicalP2PTunnelPart part) {
                super(part, MekCapabilities.GAS.block());
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static abstract class NullChemicalHandler<C extends Chemical<C>, S extends ChemicalStack<C>>
    implements IChemicalHandler<C, S> {
        private static final IGasHandler GAS = new OfGas();
        private static final IInfusionHandler INFUSION = new OfInfusion();
        private static final IPigmentHandler PIGMENT = new OfPigment();
        private static final ISlurryHandler SLURRY = new OfSlurry();

        private NullChemicalHandler() {
        }

        public int getTanks() {
            return 0;
        }

        public S getChemicalInTank(int tank) {
            return (S)this.getEmptyStack();
        }

        public void setChemicalInTank(int tank, S stack) {
            throw new UnsupportedOperationException();
        }

        public long getTankCapacity(int tank) {
            return 0L;
        }

        public boolean isValid(int tank, S stack) {
            return false;
        }

        public S insertChemical(int tank, S stack, Action action) {
            return stack;
        }

        public S extractChemical(int tank, long maxAmount, Action action) {
            return (S)this.getEmptyStack();
        }

        private static final class OfGas
        extends NullChemicalHandler<Gas, GasStack>
        implements IGasHandler {
            private OfGas() {
            }
        }

        private static final class OfInfusion
        extends NullChemicalHandler<InfuseType, InfusionStack>
        implements IInfusionHandler {
            private OfInfusion() {
            }
        }

        private static final class OfPigment
        extends NullChemicalHandler<Pigment, PigmentStack>
        implements IPigmentHandler {
            private OfPigment() {
            }
        }

        private static final class OfSlurry
        extends NullChemicalHandler<Slurry, SlurryStack>
        implements ISlurryHandler {
            private OfSlurry() {
            }
        }
    }
}

