/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import me.ramidzkh.mekae2.util.ChemicalBridge;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class GenericStackChemicalStorage<C extends Chemical<C>, S extends ChemicalStack<C>>
implements IChemicalHandler<C, S> {
    private final GenericInternalInventory inv;
    private final byte form;

    private GenericStackChemicalStorage(GenericInternalInventory inv, byte form) {
        this.inv = inv;
        this.form = form;
    }

    public int getTanks() {
        return this.inv.size();
    }

    public S getChemicalInTank(int tank) {
        MekanismKey what;
        AEKey aEKey = this.inv.getKey(tank);
        if (aEKey instanceof MekanismKey && (what = (MekanismKey)aEKey).getForm() == this.form) {
            return (S)what.withAmount(this.inv.getAmount(tank));
        }
        return (S)this.getEmptyStack();
    }

    public void setChemicalInTank(int tank, S stack) {
        throw new UnsupportedOperationException();
    }

    public long getTankCapacity(int tank) {
        return this.inv.getCapacity(MekanismKeyType.TYPE);
    }

    public boolean isValid(int tank, S stack) {
        MekanismKey what = MekanismKey.of(stack);
        return what == null || this.inv.isAllowed((AEKey)what);
    }

    public S insertChemical(int tank, S stack, Action action) {
        MekanismKey what = MekanismKey.of(stack);
        if (what == null) {
            return stack;
        }
        long remainder = stack.getAmount() - this.inv.insert(tank, (AEKey)what, stack.getAmount(), Actionable.of((IFluidHandler.FluidAction)action.toFluidAction()));
        if (remainder == 0L) {
            return (S)this.getEmptyStack();
        }
        return ChemicalBridge.withAmount(stack, remainder);
    }

    public S extractChemical(int tank, long amount, Action action) {
        MekanismKey what;
        AEKey aEKey = this.inv.getKey(tank);
        if (!(aEKey instanceof MekanismKey) || (what = (MekanismKey)aEKey).getForm() != this.form) {
            return (S)this.getEmptyStack();
        }
        long extracted = this.inv.extract(tank, (AEKey)what, amount, Actionable.of((IFluidHandler.FluidAction)action.toFluidAction()));
        if (extracted > 0L) {
            return (S)what.withAmount(extracted);
        }
        return (S)this.getEmptyStack();
    }

    public static final class OfSlurry
    extends GenericStackChemicalStorage<Slurry, SlurryStack>
    implements ISlurryHandler {
        public OfSlurry(GenericInternalInventory inv) {
            super(inv, (byte)3);
        }
    }

    public static final class OfPigment
    extends GenericStackChemicalStorage<Pigment, PigmentStack>
    implements IPigmentHandler {
        public OfPigment(GenericInternalInventory inv) {
            super(inv, (byte)2);
        }
    }

    public static final class OfInfusion
    extends GenericStackChemicalStorage<InfuseType, InfusionStack>
    implements IInfusionHandler {
        public OfInfusion(GenericInternalInventory inv) {
            super(inv, (byte)1);
        }
    }

    public static final class OfGas
    extends GenericStackChemicalStorage<Gas, GasStack>
    implements IGasHandler {
        public OfGas(GenericInternalInventory inv) {
            super(inv, (byte)0);
        }
    }
}

