/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2;

import appeng.api.parts.IPartItem;
import appeng.hooks.ticking.TickHandler;
import appeng.parts.p2p.P2PTunnelPart;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.capabilities.BlockCapability;

public class MultipleCapabilityP2PTunnelPart<P extends MultipleCapabilityP2PTunnelPart<P>>
extends P2PTunnelPart<P> {
    private final Map<BlockCapability<?, Direction>, CapabilitySetInner<?, P>> capabilities;
    private boolean inBlockUpdate = false;
    int accessDepth = 0;

    public MultipleCapabilityP2PTunnelPart(IPartItem<?> partItem, Function<P, Collection<CapabilitySet<?>>> capabilities) {
        super(partItem);
        MultipleCapabilityP2PTunnelPart part = this;
        this.capabilities = capabilities.apply((P)((Object)part)).stream().collect(Collectors.toMap(CapabilitySet::capability, set -> set.toInner(part)));
    }

    private <T> CapabilitySetInner<T, P> getSet(BlockCapability<T, Direction> capability) {
        return this.capabilities.get(capability);
    }

    protected <T> T getCapability(BlockCapability<T, Direction> capability) {
        CapabilitySetInner<T, P> set = this.getSet(capability);
        if (this.isOutput()) {
            return set.outputHandler();
        }
        return set.inputHandler();
    }

    protected final <C> CapabilityGuard<C, P> getAdjacentCapability(BlockCapability<C, Direction> capability) {
        ++this.accessDepth;
        return this.getSet(capability).guard();
    }

    protected final <C> CapabilityGuard<C, P> getInputCapability(BlockCapability<C, Direction> capability) {
        MultipleCapabilityP2PTunnelPart input = (MultipleCapabilityP2PTunnelPart)this.getInput();
        return input == null ? this.getSet(capability).empty() : input.getAdjacentCapability(capability);
    }

    BlockPos getFacingPos() {
        return this.getHost().getLocation().getPos().relative(this.getSide());
    }

    void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                this.getHost().notifyNeighborNow(this.getSide());
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    public void onTunnelNetworkChange() {
        TickHandler.instance().addCallable((LevelAccessor)this.getLevel(), () -> {
            if (this.getMainNode().isReady()) {
                this.sendBlockUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.getFacingPos().equals((Object)neighbor)) {
            return;
        }
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                if (this.isOutput()) {
                    MultipleCapabilityP2PTunnelPart input = (MultipleCapabilityP2PTunnelPart)this.getInput();
                    if (input != null) {
                        input.sendBlockUpdate();
                    }
                } else {
                    for (MultipleCapabilityP2PTunnelPart output : this.getOutputs()) {
                        output.sendBlockUpdate();
                    }
                }
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    private record CapabilitySetInner<C, P extends MultipleCapabilityP2PTunnelPart<P>>(CapabilityGuard<C, P> guard, CapabilityGuard<C, P> empty, C inputHandler, C outputHandler) {
    }

    protected static class CapabilityGuard<C, P extends MultipleCapabilityP2PTunnelPart<P>>
    implements AutoCloseable {
        protected final C emptyHandler;
        private final P part;
        private final BlockCapability<C, Direction> capability;

        public CapabilityGuard(P part, BlockCapability<C, Direction> capability, C emptyHandler) {
            this.part = part;
            this.capability = capability;
            this.emptyHandler = emptyHandler;
        }

        public C get() {
            if (((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth == 1) {
                Object cap;
                if (this.part.isActive() && (cap = this.part.getLevel().getCapability(this.capability, ((MultipleCapabilityP2PTunnelPart)((Object)this.part)).getFacingPos(), (Object)this.part.getSide().getOpposite())) != null) {
                    return (C)cap;
                }
                return this.emptyHandler;
            }
            return this.emptyHandler;
        }

        @Override
        public void close() {
            if (--((MultipleCapabilityP2PTunnelPart)((Object)this.part)).accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }

    public record CapabilitySet<C>(BlockCapability<C, Direction> capability, C inputHandler, C outputHandler, C emptyHandler) {
        private <P extends MultipleCapabilityP2PTunnelPart<P>> CapabilitySetInner<C, P> toInner(P part) {
            return new CapabilitySetInner<C, P>(new CapabilityGuard<C, P>(part, this.capability(), this.emptyHandler()), new EmptyCapabilityGuard<C, P>(part, this.capability(), this.emptyHandler()), this.inputHandler(), this.outputHandler());
        }
    }

    private static class EmptyCapabilityGuard<C, P extends MultipleCapabilityP2PTunnelPart<P>>
    extends CapabilityGuard<C, P>
    implements AutoCloseable {
        public EmptyCapabilityGuard(P part, BlockCapability<C, Direction> capability, C emptyHandler) {
            super(part, capability, emptyHandler);
        }

        @Override
        public void close() {
        }

        @Override
        public C get() {
            return (C)this.emptyHandler;
        }
    }
}

