/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.ae2.stack;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEKey;
import appeng.core.AELog;
import me.ramidzkh.mekae2.MekCapabilities;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import me.ramidzkh.mekae2.ae2.MekanismKeyType;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;

public class MekanismStackImportStrategy
implements StackImportStrategy {
    private final BlockCapabilityCache<? extends IChemicalHandler, Direction>[] lookups;

    public MekanismStackImportStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.lookups = new BlockCapabilityCache[]{BlockCapabilityCache.create(MekCapabilities.GAS.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide), BlockCapabilityCache.create(MekCapabilities.INFUSION.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide), BlockCapabilityCache.create(MekCapabilities.PIGMENT.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide), BlockCapabilityCache.create(MekCapabilities.SLURRY.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide)};
    }

    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(MekanismKeyType.TYPE)) {
            return false;
        }
        for (BlockCapabilityCache<? extends IChemicalHandler, Direction> lookup : this.lookups) {
            IChemicalHandler adjacentHandler = (IChemicalHandler)lookup.getCapability();
            if (adjacentHandler == null) continue;
            long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)MekanismKeyType.TYPE.getAmountPerOperation();
            IStorageService inv = context.getInternalStorage();
            for (int i = 0; i < adjacentHandler.getTanks() && remainingTransferAmount > 0L; ++i) {
                long amountForThisResource;
                long amount;
                ChemicalStack stack = adjacentHandler.getChemicalInTank(i);
                MekanismKey resource = MekanismKey.of(stack);
                if (resource == null || !context.isInFilter((AEKey)resource) || (amount = adjacentHandler.extractChemical(resource.withAmount(amountForThisResource = inv.getInventory().insert((AEKey)resource, remainingTransferAmount, Actionable.SIMULATE, context.getActionSource())), Action.EXECUTE).getAmount()) <= 0L) continue;
                long inserted = inv.getInventory().insert((AEKey)resource, amount, Actionable.MODULATE, context.getActionSource());
                if (inserted < amount) {
                    long leftover = amount - inserted;
                    if ((leftover = adjacentHandler.insertChemical(resource.withAmount(leftover), Action.EXECUTE).getAmount()) > 0L) {
                        AELog.warn((String)"Extracted %dx%s from adjacent storage and voided it because network refused insert", (Object[])new Object[]{leftover, resource});
                    }
                }
                long opsUsed = Math.max(1L, inserted / (long)MekanismKeyType.TYPE.getAmountPerOperation());
                context.reduceOperationsRemaining(opsUsed);
                remainingTransferAmount -= inserted;
            }
        }
        return false;
    }
}

