/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import java.io.File;
import java.util.function.Supplier;
import net.creeperhost.chickens.ChickensClient;
import net.creeperhost.chickens.api.ChickenAPI;
import net.creeperhost.chickens.api.ChickenTransformationRecipe;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.config.ChickenConfig;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.entity.EggTimer;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.init.ModContainers;
import net.creeperhost.chickens.init.ModEntities;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.init.ModRecipes;
import net.creeperhost.chickens.init.ModSounds;
import net.creeperhost.chickens.network.PacketHandler;
import net.creeperhost.chickens.polylib.ItemHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chickens {
    public static final String MOD_ID = "chickens";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final File CONFIG_DIR = new File("config/chickens");
    public static final File CONFIG_FILE = new File(CONFIG_DIR, "chickens.json");

    public static void init() {
        Config.init();
        for (ChickenConfig chickenConfig : Config.INSTANCE.chickens) {
            ResourceLocation texture = new ResourceLocation(MOD_ID, "textures/entity/" + new ResourceLocation(chickenConfig.name).getPath() + ".png");
            if (chickenConfig.name.equalsIgnoreCase(ChickensRegistry.VANILLA_CHICKEN.toString())) {
                texture = new ResourceLocation("minecraft", "textures/entity/chicken.png");
            }
            ChickensRegistryItem chickensRegistryItem2 = new ChickensRegistryItem(new ResourceLocation(chickenConfig.name), new ResourceLocation(chickenConfig.name).getPath(), texture, new ItemHolder(chickenConfig.lay_item.getType(), chickenConfig.lay_item.getId(), chickenConfig.lay_item.getNbt(), chickenConfig.lay_item.getQuantity()), chickenConfig.colour, chickenConfig.lay_coefficient, chickenConfig.breed_speed_multiplier, ChickensRegistry.getByResourceLocation(new ResourceLocation(chickenConfig.parent_1)), ChickensRegistry.getByResourceLocation(new ResourceLocation(chickenConfig.parent_2)));
            ChickensRegistry.register(chickensRegistryItem2);
        }
        ModBlocks.BLOCKS.register();
        ModEntities.ENTITIES.register();
        ModBlocks.TILES_ENTITIES.register();
        ModItems.ITEMS.register();
        ModItems.TABS.register();
        ModContainers.CONTAINERS.register();
        ModSounds.SOUNDS.register();
        if (Platform.getEnv() == Dist.CLIENT) {
            ClientLifecycleEvent.CLIENT_SETUP.register(ChickensClient::clientSetup);
        }
        ModEntities.CHICKENS.forEach((chickensRegistryItem, entityTypeSupplier) -> EntityAttributeRegistry.register((Supplier)entityTypeSupplier, EntityChickensChicken::prepareAttributes));
        InteractionEvent.INTERACT_ENTITY.register(Chickens::onEntityInteract);
        PacketHandler.init();
        EggTimer.init();
        if (Platform.isFabric()) {
            ModEntities.CHICKENS.forEach((chickensRegistryItem, entityTypeSupplier) -> ModEntities.registerSpawn((EntityType)entityTypeSupplier.get(), chickensRegistryItem));
        }
        LifecycleEvent.SETUP.register(ModRecipes::init);
    }

    private static EventResult onEntityInteract(Player player, Entity entity, InteractionHand interactionHand) {
        Level level = player.level();
        if (!player.getItemInHand(interactionHand).isEmpty()) {
            for (ChickenTransformationRecipe transformationRecipe : ChickenAPI.TRANSFORMATION_RECIPES) {
                Entity newEntity;
                if (transformationRecipe.getEntityTypeIn() != entity.getType() || !ItemStack.isSameItem((ItemStack)player.getItemInHand(interactionHand), (ItemStack)transformationRecipe.getStack()) || (newEntity = transformationRecipe.getEntityTypeOut().create(level)) == null) continue;
                newEntity.setPos(entity.position());
                level.addFreshEntity(newEntity);
                entity.remove(Entity.RemovalReason.DISCARDED);
                if (player.isCreative()) continue;
                player.getItemInHand(interactionHand).shrink(1);
            }
        }
        return EventResult.pass();
    }
}

