/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ChickenStats {
    public int gain;
    public int growth;
    public int strength;
    public int lifespan;

    public ChickenStats(int gain, int growth, int strength, int lifespan) {
        this.gain = gain;
        this.growth = growth;
        this.strength = strength;
        this.lifespan = lifespan;
    }

    public ChickenStats(ItemStack stack) {
        this.read(stack);
    }

    public void write(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        tag.putInt("gain", this.gain);
        tag.putInt("growth", this.growth);
        tag.putInt("strength", this.strength);
        tag.putInt("lifespan", this.lifespan);
        stack.getOrCreateTag().put("stats", (Tag)tag);
    }

    public void read(ItemStack stack) {
        if (!stack.hasTag()) {
            this.gain = 1;
            this.growth = 1;
            this.strength = 1;
            this.lifespan = 100;
            this.write(stack);
        } else if (stack.getTag() != null && stack.getTag().getCompound("stats") != null) {
            CompoundTag tag = stack.getTag().getCompound("stats");
            this.gain = tag.contains("gain") ? tag.getInt("gain") : 1;
            this.growth = tag.contains("growth") ? tag.getInt("growth") : 1;
            this.strength = tag.contains("strength") ? tag.getInt("strength") : 1;
            this.lifespan = tag.contains("lifespan") ? tag.getInt("lifespan") : 100;
        }
    }

    public void setGain(int gain) {
        if (gain > 10) {
            gain = 10;
        }
        this.gain = gain;
    }

    public int getGain() {
        return this.gain;
    }

    public void setGrowth(int growth) {
        if (growth > 10) {
            growth = 10;
        }
        this.growth = growth;
    }

    public int getGrowth() {
        return this.growth;
    }

    public void setStrength(int strength) {
        if (strength > 10) {
            strength = 10;
        }
        this.strength = strength;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getLifespan() {
        return this.lifespan;
    }

    public void setLifespan(int lifespan) {
        if (lifespan > 100) {
            lifespan = 100;
        }
        this.lifespan = lifespan;
    }

    public void reduceLifespan(int value) {
        this.setLifespan(this.getLifespan() - value);
    }
}

