/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.api;

import net.creeperhost.chickens.polylib.CommonTags;
import net.creeperhost.chickens.polylib.ItemHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ChickensRegistryItem {
    public ResourceLocation registryName;
    public String entityName;
    public ItemHolder layItem;
    public int bgColor;
    public ResourceLocation texture;
    public ChickensRegistryItem parent1;
    public ChickensRegistryItem parent2;
    public boolean isEnabled = true;
    public float layCoefficient;
    public float breedSpeedMultiplier;

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor) {
        this(registryName, entityName, texture, layItem, bgColor, 1.0f, 1.0f);
    }

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor, float layCoefficient, float breedSpeedMultiplier) {
        this(registryName, entityName, texture, layItem, bgColor, layCoefficient, breedSpeedMultiplier, null, null);
    }

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor, @Nullable ChickensRegistryItem parent1, @Nullable ChickensRegistryItem parent2) {
        this(registryName, entityName, texture, layItem, bgColor, 1.0f, 1.0f, parent1, parent2);
    }

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemStack layItem, int bgColor, float layCoefficient, float breedSpeedMultiplier, @Nullable ChickensRegistryItem parent1, @Nullable ChickensRegistryItem parent2) {
        this(registryName, entityName, texture, new ItemHolder(layItem, false), bgColor, layCoefficient, breedSpeedMultiplier, parent1, parent2);
    }

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemHolder layItem, int bgColor, @Nullable ChickensRegistryItem parent1, @Nullable ChickensRegistryItem parent2) {
        this(registryName, entityName, texture, layItem, bgColor, 1.0f, 1.0f, parent1, parent2);
    }

    public ChickensRegistryItem(ResourceLocation registryName, String entityName, ResourceLocation texture, ItemHolder layItem, int bgColor, float layCoefficient, float breedSpeedMultiplier, @Nullable ChickensRegistryItem parent1, @Nullable ChickensRegistryItem parent2) {
        this.registryName = registryName;
        this.entityName = entityName;
        this.layItem = layItem;
        this.bgColor = bgColor;
        this.texture = texture;
        this.layCoefficient = layCoefficient;
        this.breedSpeedMultiplier = breedSpeedMultiplier;
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    public ItemHolder getLayItemHolder() {
        return this.layItem;
    }

    public ChickensRegistryItem setLayCoefficient(float coef) {
        this.layCoefficient = coef;
        return this;
    }

    public ChickensRegistryItem setBreedSpeedMultiplier(float breedSpeedMultiplier) {
        this.breedSpeedMultiplier = breedSpeedMultiplier;
        return this;
    }

    public String getEntityName() {
        return this.entityName;
    }

    @Nullable
    public ChickensRegistryItem getParent1() {
        return this.parent1;
    }

    @Nullable
    public ChickensRegistryItem getParent2() {
        return this.parent2;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ItemStack createLayItem() {
        return this.layItem.getStack();
    }

    public int getTier() {
        if (this.parent1 == null || this.parent2 == null) {
            return 1;
        }
        return Math.max(this.parent1.getTier(), this.parent2.getTier()) + 1;
    }

    public boolean isChildOf(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        return this.parent1 == parent1 && this.parent2 == parent2 || this.parent1 == parent2 && this.parent2 == parent1;
    }

    public boolean isDye() {
        if (this.layItem == null || this.layItem.getStack() == null) {
            return false;
        }
        return this.layItem.getStack().is(CommonTags.DYE);
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public int getMinLayTime() {
        return (int)Math.max((float)(6000 * this.getTier()) * this.layCoefficient, 1.0f);
    }

    public int getMaxLayTime() {
        return 2 * this.getMinLayTime();
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public boolean isEnabled() {
        return !(!this.isEnabled || this.parent1 != null && !this.parent1.isEnabled() || this.parent2 != null && !this.parent2.isEnabled());
    }

    public void setLayItem(ItemHolder itemHolder) {
        this.layItem = itemHolder;
    }

    public void setLayItem(ItemStack itemstack) {
        this.setLayItem(new ItemHolder(itemstack, false));
    }

    public void setNoParents() {
        this.parent1 = null;
        this.parent2 = null;
    }

    public ChickensRegistryItem setParentsNew(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        return this;
    }

    @Deprecated
    public void setParents(ChickensRegistryItem parent1, ChickensRegistryItem parent2) {
        this.parent1 = parent1;
        this.parent2 = parent2;
    }

    public boolean isBreedable() {
        return this.parent1 != null && this.parent2 != null;
    }
}

