/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.block;

import dev.architectury.registry.menu.MenuRegistry;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.polylib.blocks.PolyEntityBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BreederBlock
extends PolyEntityBlock {
    public static final BooleanProperty IS_BREEDING = BooleanProperty.create((String)"is_breeding");
    public static final BooleanProperty HAS_SEEDS = BooleanProperty.create((String)"has_seeds");

    public BreederBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).noOcclusion().strength(2.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)IS_BREEDING, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false)));
        this.setBlockEntity(() -> ModBlocks.BREEDER_TILE.get(), true);
    }

    public InteractionResult use(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        if (!level.isClientSide) {
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)blockEntity), packetBuffer -> packetBuffer.writeBlockPos(blockEntity.getBlockPos()));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)IS_BREEDING, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_SEEDS, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{IS_BREEDING, HAS_SEEDS});
    }

    public boolean skipRendering(BlockState blockState, BlockState blockState2, Direction direction) {
        return false;
    }
}

