/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import net.creeperhost.chickens.api.ChickenStats;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.block.BreederBlock;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.BreederMenu;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.chickens.polylib.CommonTags;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.FloatData;
import net.creeperhost.polylib.helpers.ContainerUtil;
import net.creeperhost.polylib.inventory.item.ContainerAccessControl;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.creeperhost.polylib.inventory.item.SerializableContainer;
import net.creeperhost.polylib.inventory.item.SimpleItemInventory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BreederBlockEntity
extends PolyBlockEntity
implements ItemInventoryBlock,
MenuProvider {
    public final SimpleItemInventory inventory = new SimpleItemInventory((BlockEntity)this, 6).setSlotValidator(0, CommonTags::isSeeds).setSlotValidator(1, e -> e.is((Item)ModItems.CHICKEN_ITEM.get())).setSlotValidator(2, e -> e.is((Item)ModItems.CHICKEN_ITEM.get()));
    public final FloatData progress = (FloatData)this.register("progress", (AbstractDataStore)new FloatData(0.0f), new int[]{9});

    public BreederBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.BREEDER_TILE.get(), pos, state);
    }

    public void tick() {
        super.tick();
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack seeds = this.inventory.getItem(0);
        ItemStack chicken1 = this.inventory.getItem(1);
        ItemStack chicken2 = this.inventory.getItem(2);
        boolean canWork = chicken1.getItem() instanceof ItemChicken && chicken2.getItem() instanceof ItemChicken && CommonTags.isSeeds(seeds);
        this.setState(canWork);
        if (!canWork) {
            this.progress.set((Object)Float.valueOf(0.0f));
            return;
        }
        ChickensRegistryItem regItem1 = ChickensRegistry.getByRegistryName(ItemChicken.getTypeFromStack(chicken1));
        ChickensRegistryItem regItem2 = ChickensRegistry.getByRegistryName(ItemChicken.getTypeFromStack(chicken2));
        float timeMultiplier = (regItem1 == null ? 1.0f : regItem1.breedSpeedMultiplier) * (regItem2 == null ? 1.0f : regItem2.breedSpeedMultiplier);
        if (((Float)this.progress.get()).floatValue() < (float)Config.INSTANCE.breederMaxProcessTime) {
            this.progress.add(this.getProgressIncrement(timeMultiplier));
            return;
        }
        ChickensRegistryItem baby = ChickensRegistry.getRandomChild(regItem1, regItem2);
        if (baby == null) {
            this.progress.set((Object)Float.valueOf(0.0f));
            return;
        }
        ItemStack chickenStack = ItemChickenEgg.of(baby, this.level.random.nextDouble() < Config.INSTANCE.onLaidViabilityChange);
        ChickenStats babyStats = this.increaseStats(chickenStack, chicken1, chicken2, this.level.random);
        babyStats.write(chickenStack);
        ChickenStats chickenStats = new ChickenStats(chicken1);
        int count = Math.max(1, (1 + chickenStats.getGain()) / 3);
        chickenStack.setCount(count);
        if (ContainerUtil.insertStack((ItemStack)chickenStack, (Container)this.inventory, (boolean)true) == 0) {
            ContainerUtil.insertStack((ItemStack)chickenStack, (Container)this.inventory);
            int random = this.level.getRandom().nextInt(1, 5);
            if (random >= 4) {
                this.damageChicken(1);
                this.damageChicken(2);
            }
            this.level.playSound(null, this.getBlockPos(), SoundEvents.CHICKEN_EGG, SoundSource.NEUTRAL, 0.5f, 0.8f);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HEART, (double)this.getBlockPos().getX() + 0.5, (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ() + 0.5, 8, 0.45, 0.45, 0.45, 0.0125);
            if (this.level.random.nextDouble() < Config.INSTANCE.breederFoodConsumptionChance) {
                seeds.shrink(1);
            }
            this.progress.set((Object)Float.valueOf(0.0f));
        }
    }

    public SerializableContainer getContainer(@Nullable Direction side) {
        if (side != Direction.DOWN) {
            return new ContainerAccessControl((Container)this.inventory, 0, 6).slotInsertCheck(1, stack -> stack.getCount() == 1 && this.inventory.getItem(1).isEmpty()).slotInsertCheck(2, stack -> stack.getCount() == 1 && this.inventory.getItem(2).isEmpty()).containerInsertCheck((slot, stack) -> slot <= 2);
        }
        return new ContainerAccessControl((Container)this.inventory, 0, 6).slotInsertCheck(1, stack -> stack.getCount() == 1 && this.inventory.getItem(1).isEmpty()).slotInsertCheck(2, stack -> stack.getCount() == 1 && this.inventory.getItem(2).isEmpty()).containerInsertCheck((slot, stack) -> slot <= 2).containerRemoveCheck((slot, stack) -> slot > 2);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new BreederMenu(i, inventory, this);
    }

    public void writeExtraData(CompoundTag nbt) {
        this.inventory.serialize(nbt);
    }

    public void readExtraData(CompoundTag nbt) {
        this.inventory.deserialize(nbt);
    }

    public void setState(boolean canWork) {
        boolean hasSeeds = !this.inventory.getItem(0).isEmpty();
        this.level.setBlock(this.getBlockPos(), (BlockState)((BlockState)this.getBlockState().setValue((Property)BreederBlock.HAS_SEEDS, (Comparable)Boolean.valueOf(hasSeeds))).setValue((Property)BreederBlock.IS_BREEDING, (Comparable)Boolean.valueOf(canWork)), 3);
    }

    public float getProgressIncrement(float speedMultiplier) {
        ChickenStats chickenStats1 = new ChickenStats(this.inventory.getItem(1));
        ChickenStats chickenStats2 = new ChickenStats(this.inventory.getItem(2));
        float progress = chickenStats1.getGain() + chickenStats2.getGain();
        if (progress > 50.0f) {
            progress = 50.0f;
        }
        return progress * speedMultiplier;
    }

    public void damageChicken(int slot) {
        if (!this.inventory.getItem(slot).isEmpty() && this.inventory.getItem(slot).getItem() instanceof ItemChicken) {
            ItemStack copy = this.inventory.getItem(slot).copy();
            ChickenStats chickenStats = new ChickenStats(copy);
            int life = chickenStats.getLifespan() - 1;
            if (life > 0) {
                chickenStats.setLifespan(life);
                chickenStats.write(copy);
                this.inventory.setItem(slot, copy);
            } else {
                this.inventory.setItem(slot, ItemStack.EMPTY);
            }
        }
    }

    private ChickenStats increaseStats(ItemStack baby, ItemStack parent1, ItemStack parent2, RandomSource rand) {
        ChickenStats babyStats = new ChickenStats(baby);
        ChickenStats parent1Stats = new ChickenStats(parent1);
        ChickenStats parent2Stats = new ChickenStats(parent2);
        babyStats.setGrowth(this.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getGrowth(), parent2Stats.getGrowth(), rand));
        babyStats.setGain(this.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getGain(), parent2Stats.getGain(), rand));
        babyStats.setStrength(this.calculateNewStat(parent1Stats.getStrength(), parent2Stats.getStrength(), parent1Stats.getStrength(), parent2Stats.getStrength(), rand));
        return babyStats;
    }

    private int calculateNewStat(int thisStrength, int mateStrength, int stat1, int stat2, RandomSource rand) {
        int mutation = rand.nextInt(2) + 1;
        int newStatValue = (stat1 * thisStrength + stat2 * mateStrength) / (thisStrength + mateStrength) + mutation;
        if (newStatValue <= 1) {
            return 1;
        }
        return Math.min(newStatValue, 10);
    }
}

