/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.EggCrackerMenu;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.IntData;
import net.creeperhost.polylib.helpers.ContainerUtil;
import net.creeperhost.polylib.inventory.fluid.FluidManager;
import net.creeperhost.polylib.inventory.fluid.PolyBlockTank;
import net.creeperhost.polylib.inventory.fluid.PolyFluidBlock;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandlerItem;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.item.ContainerAccessControl;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.creeperhost.polylib.inventory.item.SerializableContainer;
import net.creeperhost.polylib.inventory.item.SimpleItemInventory;
import net.creeperhost.polylib.inventory.power.EnergyManager;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.creeperhost.polylib.inventory.power.PolyBlockEnergyStorage;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class EggCrackerBlockEntity
extends PolyBlockEntity
implements ItemInventoryBlock,
MenuProvider,
PolyFluidBlock,
PolyEnergyBlock,
RedstoneActivatedBlock {
    public final PolyTank tank = new PolyBlockTank((BlockEntity)this, FluidManager.BUCKET * 16L);
    public final PolyEnergyStorage energy = new PolyBlockEnergyStorage((BlockEntity)this, 128000L);
    public final SimpleItemInventory inventory = new SimpleItemInventory((BlockEntity)this, 9).setSlotValidator(0, stack -> stack.getItem() instanceof ItemChickenEgg).setSlotValidator(7, FluidManager::isFluidItem).setSlotValidator(8, stack -> EnergyManager.isEnergyItem((ItemStack)stack) && EnergyManager.getHandler((ItemStack)stack).canExtract());
    public final IntData progress = (IntData)this.register("progress", (AbstractDataStore)new IntData(10), new int[]{9});

    public EggCrackerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.EGG_CRACKER_TILE.get(), pos, state);
    }

    public void tick() {
        ItemChickenEgg eggItem;
        ItemStack input;
        Item item;
        ItemStack fluidItem;
        PolyFluidHandlerItem itemFluidHandler;
        IPolyEnergyStorageItem storage;
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        if (Config.INSTANCE.enableEnergy && (storage = EnergyManager.getHandler((ItemStack)this.inventory.getItem(8))) != null && EnergyManager.transferEnergy((IPolyEnergyStorage)storage, (IPolyEnergyStorage)this.energy) > 0L) {
            this.inventory.setItem(8, storage.getContainer());
        }
        if (!FluidManager.transferFluid((PolyFluidHandler)this.tank, (PolyFluidHandler)(itemFluidHandler = FluidManager.getHandler((ItemStack)(fluidItem = this.inventory.getItem(7))))).isEmpty()) {
            this.inventory.setItem(7, itemFluidHandler.getContainer());
        }
        if (!((item = (input = this.inventory.getItem(0)).getItem()) instanceof ItemChickenEgg) || (eggItem = (ItemChickenEgg)item).getType(input) == null) {
            this.progress.set((Object)0);
            return;
        }
        if ((Integer)this.progress.get() < Config.INSTANCE.crackerProcessTime) {
            if (this.isTileEnabled() && this.consumeEnergy()) {
                this.progress.inc();
            }
            return;
        }
        ChickensRegistryItem type = eggItem.getType(input);
        ItemStack drop = type.getLayItemHolder().getStack();
        if (!drop.isEmpty()) {
            if (eggItem.isViable(input)) {
                int remaining = ContainerUtil.insertStack((ItemStack)drop, (Container)this.inventory, (boolean)true);
                if (remaining == 0) {
                    ContainerUtil.insertStack((ItemStack)drop, (Container)this.inventory);
                    input.shrink(1);
                    this.progress.set((Object)0);
                }
            } else {
                input.shrink(1);
                this.progress.set((Object)0);
            }
        } else {
            int amount;
            Fluid fluid = type.getLayItemHolder().getFluid();
            FluidStack fluidStack = FluidStack.create((Fluid)fluid, (long)(amount = type.getLayItemHolder().getAmount()));
            if (fluidStack.isEmpty()) {
                return;
            }
            if (this.tank.isEmpty() || this.tank.fill(fluidStack, true) == fluidStack.getAmount()) {
                this.tank.fill(fluidStack, false);
                input.shrink(1);
                this.progress.set((Object)0);
            }
        }
    }

    private boolean consumeEnergy() {
        return !Config.INSTANCE.enableEnergy || this.energy.extractEnergy((long)Config.INSTANCE.crackerEnergyRate, false) == (long)Config.INSTANCE.crackerEnergyRate;
    }

    public void writeExtraData(CompoundTag nbt) {
        nbt.put("fluid_tank", (Tag)this.tank.serialize(new CompoundTag()));
        this.inventory.serialize(nbt);
        this.energy.serialize(nbt);
    }

    public void readExtraData(CompoundTag nbt) {
        this.tank.deserialize(nbt.getCompound("fluid_tank"));
        this.inventory.deserialize(nbt);
        this.energy.deserialize(nbt);
    }

    public SerializableContainer getContainer(@Nullable Direction side) {
        ContainerAccessControl ac = new ContainerAccessControl((Container)this.inventory, 0, Config.INSTANCE.enableEnergy ? 9 : 8).containerInsertCheck((slot, stack) -> slot == 0 || slot > 6).slotRemoveCheck(0, stack -> false).slotInsertCheck(7, stack -> stack.getCount() == 1 && this.inventory.getItem(7).isEmpty()).slotRemoveCheck(7, stack -> {
            PolyFluidHandlerItem handler = FluidManager.getHandler((ItemStack)stack);
            if (handler == null) {
                return true;
            }
            if (handler.getTanks() == 1 && handler.getFluidInTank(0).getAmount() >= handler.getTankCapacity(0)) {
                return true;
            }
            if (this.tank.isEmpty()) {
                return false;
            }
            return handler.fill(FluidStack.create((FluidStack)this.tank.getFluid(), (long)FluidManager.BUCKET), true) == 0L;
        });
        if (Config.INSTANCE.enableEnergy) {
            ac.slotInsertCheck(8, stack -> stack.getCount() == 1 && this.inventory.getItem(8).isEmpty());
            ac.slotRemoveCheck(8, stack -> {
                IPolyEnergyStorageItem energy = EnergyManager.getHandler((ItemStack)stack);
                return energy == null || !energy.canExtract() || energy.getEnergyStored() == 0L;
            });
        }
        return ac;
    }

    @Nullable
    public PolyFluidHandler getFluidHandler(@Nullable Direction side) {
        return this.tank;
    }

    public IPolyEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return Config.INSTANCE.enableEnergy ? this.energy : null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new EggCrackerMenu(i, inventory, this);
    }
}

