/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import dev.architectury.fluid.FluidStack;
import net.creeperhost.chickens.ChickensPlatform;
import net.creeperhost.chickens.api.ChickenStats;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.IncubatorMenu;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.FloatData;
import net.creeperhost.polylib.data.serializable.IntData;
import net.creeperhost.polylib.helpers.MathUtil;
import net.creeperhost.polylib.inventory.fluid.FluidManager;
import net.creeperhost.polylib.inventory.fluid.PolyBlockTank;
import net.creeperhost.polylib.inventory.fluid.PolyFluidBlock;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandler;
import net.creeperhost.polylib.inventory.fluid.PolyFluidHandlerItem;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.item.ContainerAccessControl;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.creeperhost.polylib.inventory.item.SerializableContainer;
import net.creeperhost.polylib.inventory.item.SimpleItemInventory;
import net.creeperhost.polylib.inventory.power.EnergyManager;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.creeperhost.polylib.inventory.power.PolyBlockEnergyStorage;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends PolyBlockEntity
implements PolyFluidBlock,
ItemInventoryBlock,
MenuProvider,
PolyEnergyBlock,
RedstoneActivatedBlock {
    public static int HEAT_INCREMENT = 4;
    public static int TEMP_MAX = 40;
    public static int TEMP_MIN = 35;
    public static int MIN_HUMIDITY = 50;
    public final PolyTank tank = new PolyBlockTank((BlockEntity)this, FluidManager.BUCKET * 16L, e -> e.getFluid().isSame((Fluid)Fluids.WATER));
    public final SimpleItemInventory inventory = new SimpleItemInventory((BlockEntity)this, 11).setMaxStackSize(1).setSlotValidator(9, stack -> FluidManager.isFluidItem((ItemStack)stack) && FluidManager.getHandler((ItemStack)stack).getFluidInTank(0).getFluid() == Fluids.WATER).setSlotValidator(10, stack -> EnergyManager.isEnergyItem((ItemStack)stack) && EnergyManager.getHandler((ItemStack)stack).canExtract()).setStackValidator((slot, stack) -> stack.getItem() instanceof ItemChickenEgg);
    public final PolyEnergyStorage energy = new PolyBlockEnergyStorage((BlockEntity)this, 128000L);
    public final IntData temperature = (IntData)this.register("temperature", (AbstractDataStore)new IntData(10), new int[]{9});
    public final FloatData humidity = (FloatData)this.register("humidity", (AbstractDataStore)new FloatData(20.0f), new int[]{9});
    public final IntData heatSetting = (IntData)((IntData)this.register("heat_setting", (AbstractDataStore)new IntData(0), new int[]{9, 2})).setValidator(e -> e >= 0 && e <= 15);

    public IncubatorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlocks.INCUBATOR_TILE.get(), blockPos, blockState);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide()) {
            return;
        }
        this.updateResources();
        if (!this.onInterval(20)) {
            return;
        }
        Holder biome = this.level.getBiome(this.getBlockPos());
        int localTemperature = ChickensPlatform.getBiomeTemperature((Holder<Biome>)biome);
        int localHumidity = ChickensPlatform.getBiomeHumidity((Holder<Biome>)biome);
        this.updateHeat(localTemperature);
        this.updateHumidity(localTemperature, localHumidity);
        this.updateIncubation();
    }

    private void updateResources() {
        IPolyEnergyStorageItem storage;
        PolyFluidHandlerItem handler;
        ItemStack bucketStack = this.inventory.getItem(9);
        if (!bucketStack.isEmpty() && FluidManager.transferFluid((PolyFluidHandler)(handler = FluidManager.getHandler((ItemStack)bucketStack)), (PolyFluidHandler)this.tank).getAmount() > 0L) {
            this.inventory.setItem(9, handler.getContainer());
        }
        if (Config.INSTANCE.enableEnergy && (storage = EnergyManager.getHandler((ItemStack)this.inventory.getItem(10))) != null && EnergyManager.transferEnergy((IPolyEnergyStorage)storage, (IPolyEnergyStorage)this.energy) > 0L) {
            this.inventory.setItem(10, storage.getContainer());
        }
    }

    private void updateHeat(int localTemperature) {
        int targetHeat = localTemperature + (Integer)this.heatSetting.get() * HEAT_INCREMENT;
        int energy = (int)Math.ceil((double)(Math.max((Integer)this.temperature.get() - localTemperature, 0) * 10) * Config.INSTANCE.incubatorEnergyMultiplier);
        if (localTemperature > (Integer)this.temperature.get()) {
            this.temperature.inc();
        } else if (this.isTileEnabled() && this.consumeEnergy(energy)) {
            if ((Integer)this.temperature.get() < targetHeat) {
                this.temperature.inc();
            } else if ((Integer)this.temperature.get() > targetHeat && (Integer)this.temperature.get() > localTemperature) {
                this.temperature.dec();
            }
        } else if ((Integer)this.temperature.get() > localTemperature) {
            this.temperature.dec();
        }
    }

    private boolean consumeEnergy(int amount) {
        if (!Config.INSTANCE.enableEnergy) {
            return true;
        }
        return this.energy.extractEnergy((long)amount, false) == (long)amount;
    }

    private void updateHumidity(int localTemperature, int localHumidity) {
        float rate = (float)((Integer)this.temperature.get() - localTemperature) / 10.0f * (((Float)this.humidity.get()).floatValue() / 100.0f);
        if (rate > 0.0f) {
            this.humidity.subtract(rate);
            this.humidity.set((Object)Float.valueOf(Math.max(((Float)this.humidity.get()).floatValue(), (float)localHumidity)));
            if (((Float)this.humidity.get()).floatValue() < 0.0f) {
                this.humidity.set((Object)Float.valueOf(0.0f));
            }
        } else if (((Float)this.humidity.get()).floatValue() < (float)localHumidity) {
            this.humidity.inc();
        } else if (((Float)this.humidity.get()).floatValue() > (float)localHumidity) {
            this.humidity.dec();
        }
        if (((Float)this.humidity.get()).floatValue() >= (float)MIN_HUMIDITY || this.tank.isEmpty() || !this.isTileEnabled()) {
            return;
        }
        float needed = (float)MIN_HUMIDITY - ((Float)this.humidity.get()).floatValue();
        float needWater = needed / 2.5f;
        int minExtract = (int)Math.ceil(needWater);
        FluidStack drained = this.tank.drain(FluidStack.create((Fluid)Fluids.WATER, (long)minExtract), false);
        if (!drained.isEmpty()) {
            this.humidity.add((float)drained.getAmount() * 2.5f);
        }
    }

    private void updateIncubation() {
        double hVal = MathUtil.clamp((double)(1.0 - (double)((Float)this.humidity.get()).floatValue() / (double)MIN_HUMIDITY), (double)0.0, (double)1.0);
        double deathChance = hVal * hVal * hVal * 0.01;
        double failureChance = (1.0 - Config.INSTANCE.incubateSuccessRate) / 100.0;
        RandomSource random = this.level.getRandom();
        for (int slot = 0; slot < 9; ++slot) {
            ItemChickenEgg eggItem;
            ItemStack stack = this.inventory.getItem(slot);
            Item item = stack.getItem();
            if (!(item instanceof ItemChickenEgg) || !(eggItem = (ItemChickenEgg)item).isViable(stack)) continue;
            if (deathChance > random.nextDouble()) {
                eggItem.setNotViable(stack);
                eggItem.setProgress(stack, 0);
                continue;
            }
            int progress = eggItem.getProgress(stack);
            if (this.isWithinHatchingTemp()) {
                if (progress < 100) {
                    if (random.nextBoolean()) continue;
                    if (failureChance > random.nextDouble()) {
                        eggItem.setNotViable(stack);
                        eggItem.setProgress(stack, 0);
                        continue;
                    }
                    eggItem.setProgress(stack, ++progress);
                    continue;
                }
                if (random.nextDouble() > 0.2) continue;
                ItemStack chicken = ItemChicken.of(eggItem.getType(stack));
                ChickenStats chickenStats = new ChickenStats(stack);
                chickenStats.write(chicken);
                if (chicken.isEmpty()) continue;
                this.inventory.setItem(slot, chicken);
                continue;
            }
            if (progress <= 0) continue;
            eggItem.incrementMissed(stack);
            int temp = (Integer)this.temperature.get();
            if (temp > TEMP_MAX) {
                double over = temp - TEMP_MAX;
                if (!((double)eggItem.getMissedCycles(stack) > 1000.0 / over)) continue;
                eggItem.setNotViable(stack);
                continue;
            }
            if (temp >= TEMP_MIN) continue;
            double over = Math.min(TEMP_MIN - temp, 5);
            if (!((double)eggItem.getMissedCycles(stack) > 1000.0 / over)) continue;
            eggItem.setNotViable(stack);
        }
    }

    public boolean isWithinHatchingTemp() {
        return (Integer)this.temperature.get() >= TEMP_MIN && (Integer)this.temperature.get() <= TEMP_MAX;
    }

    public void writeExtraData(CompoundTag nbt) {
        nbt.put("fluid_tank", (Tag)this.tank.serialize(new CompoundTag()));
        this.inventory.serialize(nbt);
        this.energy.serialize(nbt);
    }

    public void readExtraData(CompoundTag nbt) {
        this.tank.deserialize(nbt.getCompound("fluid_tank"));
        this.inventory.deserialize(nbt);
        this.energy.deserialize(nbt);
    }

    @Nullable
    public PolyFluidHandler getFluidHandler(@Nullable Direction direction) {
        return this.tank;
    }

    public SerializableContainer getContainer(@Nullable Direction side) {
        return new ContainerAccessControl((Container)this.inventory, 0, Config.INSTANCE.enableEnergy ? 11 : 10).containerRemoveCheck((slot, stack) -> {
            if (slot <= 8) {
                Item patt11035$temp = stack.getItem();
                if (!(patt11035$temp instanceof ItemChickenEgg)) {
                    return true;
                }
                ItemChickenEgg eggItem = (ItemChickenEgg)patt11035$temp;
                return !eggItem.isViable((ItemStack)stack);
            }
            if (slot == 9) {
                PolyFluidHandlerItem handler = FluidManager.getHandler((ItemStack)stack);
                if (handler == null) {
                    return true;
                }
                return handler.drain(FluidStack.create((Fluid)Fluids.WATER, (long)FluidManager.BUCKET), true).isEmpty();
            }
            if (slot == 10) {
                IPolyEnergyStorageItem energy = EnergyManager.getHandler((ItemStack)stack);
                return energy == null || !energy.canExtract() || energy.getEnergyStored() == 0L;
            }
            return true;
        });
    }

    public IPolyEnergyStorage getEnergyStorage(Direction side) {
        return Config.INSTANCE.enableEnergy ? this.energy : null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new IncubatorMenu(i, inventory, this);
    }
}

