/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.blockentities;

import net.creeperhost.chickens.block.OvoscopeBlock;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.OvoscopeMenu;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.polylib.blocks.PolyBlockEntity;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.data.serializable.IntData;
import net.creeperhost.polylib.helpers.ContainerUtil;
import net.creeperhost.polylib.inventory.item.ContainerAccessControl;
import net.creeperhost.polylib.inventory.item.ItemInventoryBlock;
import net.creeperhost.polylib.inventory.item.SerializableContainer;
import net.creeperhost.polylib.inventory.item.SimpleItemInventory;
import net.creeperhost.polylib.inventory.power.EnergyManager;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorage;
import net.creeperhost.polylib.inventory.power.IPolyEnergyStorageItem;
import net.creeperhost.polylib.inventory.power.PolyBlockEnergyStorage;
import net.creeperhost.polylib.inventory.power.PolyEnergyBlock;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class OvoscopeBlockEntity
extends PolyBlockEntity
implements ItemInventoryBlock,
MenuProvider,
PolyEnergyBlock,
RedstoneActivatedBlock {
    public final PolyEnergyStorage energy = new PolyBlockEnergyStorage((BlockEntity)this, 128000L);
    public final SimpleItemInventory inventory = new SimpleItemInventory((BlockEntity)this, 4).setMaxStackSize(1).setSlotValidator(0, stack -> stack.getItem() instanceof ItemChickenEgg).setSlotValidator(3, stack -> EnergyManager.isEnergyItem((ItemStack)stack) && EnergyManager.getHandler((ItemStack)stack).canExtract());
    public boolean scanning = false;
    public byte scanCount = 0;
    public final IntData progress = (IntData)this.register("progress", (AbstractDataStore)new IntData(10), new int[]{9});

    public OvoscopeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.OVOSCOPE_TILE.get(), pos, state);
    }

    public void tick() {
        ItemChickenEgg eggItem;
        ItemStack input;
        block13: {
            block12: {
                Item item;
                BlockEntity blockEntity;
                ItemStack nonViaStack;
                BlockEntity blockEntity2;
                IPolyEnergyStorageItem storage;
                super.tick();
                if (this.level.isClientSide()) {
                    return;
                }
                if (Config.INSTANCE.enableEnergy && (storage = EnergyManager.getHandler((ItemStack)this.inventory.getItem(3))) != null && EnergyManager.transferEnergy((IPolyEnergyStorage)storage, (IPolyEnergyStorage)this.energy) > 0L) {
                    this.inventory.setItem(3, storage.getContainer());
                }
                Direction facing = (Direction)this.getBlockState().getValue((Property)OvoscopeBlock.FACING);
                Direction viaDir = facing.getCounterClockWise(Direction.Axis.Y);
                Direction nonViaDir = facing.getClockWise(Direction.Axis.Y);
                ItemStack viaStack = this.inventory.getItem(1);
                if (!viaStack.isEmpty() && (blockEntity2 = this.level.getBlockEntity(this.getBlockPos().relative(viaDir))) instanceof Container) {
                    Container target = (Container)blockEntity2;
                    viaStack.setCount(ContainerUtil.insertStack((ItemStack)viaStack, (Container)target));
                }
                if (!(nonViaStack = this.inventory.getItem(2)).isEmpty() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(nonViaDir))) instanceof Container) {
                    Container target = (Container)blockEntity;
                    nonViaStack.setCount(ContainerUtil.insertStack((ItemStack)nonViaStack, (Container)target));
                }
                boolean outputObstructed = !this.inventory.getItem(1).isEmpty() || !this.inventory.getItem(2).isEmpty();
                input = this.inventory.getItem(0);
                if (input.isEmpty() || !((item = input.getItem()) instanceof ItemChickenEgg)) break block12;
                eggItem = (ItemChickenEgg)item;
                if (!outputObstructed) break block13;
            }
            this.progress.set((Object)0);
            this.scanning = false;
            return;
        }
        if ((Integer)this.progress.get() < Config.INSTANCE.ovoscopeProcessTime) {
            if (this.isTileEnabled() && this.consumeEnergy()) {
                this.progress.inc();
                this.scanning = true;
            } else {
                this.scanning = false;
            }
            return;
        }
        if (eggItem.isViable(input)) {
            this.inventory.setItem(1, input);
        } else {
            this.inventory.setItem(2, input);
        }
        this.inventory.setItem(0, ItemStack.EMPTY);
        this.scanning = false;
        this.progress.set((Object)0);
        this.scanCount = (byte)(this.scanCount + 1);
    }

    private boolean consumeEnergy() {
        return !Config.INSTANCE.enableEnergy || this.energy.extractEnergy((long)Config.INSTANCE.ovoscopeEnergyRate, false) == (long)Config.INSTANCE.ovoscopeEnergyRate;
    }

    public SerializableContainer getContainer(@Nullable Direction side) {
        ContainerAccessControl ac = new ContainerAccessControl((Container)this.inventory, 0, Config.INSTANCE.enableEnergy ? 4 : 2).slotRemoveCheck(0, stack -> false).slotInsertCheck(1, stack -> false).slotInsertCheck(2, stack -> false);
        if (Config.INSTANCE.enableEnergy) {
            ac.slotRemoveCheck(3, stack -> {
                IPolyEnergyStorageItem energy = EnergyManager.getHandler((ItemStack)stack);
                return energy == null || !energy.canExtract() || energy.getEnergyStored() == 0L;
            });
        }
        return ac;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new OvoscopeMenu(i, inventory, this);
    }

    public IPolyEnergyStorage getEnergyStorage(@Nullable Direction side) {
        return Config.INSTANCE.enableEnergy ? this.energy : null;
    }

    public void writeExtraData(CompoundTag nbt) {
        this.inventory.serialize(nbt);
        this.energy.serialize(nbt);
    }

    public void readExtraData(CompoundTag nbt) {
        this.inventory.deserialize(nbt);
        this.energy.deserialize(nbt);
    }
}

