/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.client;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.creeperhost.chickens.item.ItemChicken;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RenderChickenItem {
    public static void renderByItem(ItemStack itemStack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        if (mc.level == null) {
            return;
        }
        String s = ItemChicken.getTypeFromStack(itemStack);
        if (s == null || s.isEmpty()) {
            ChickensRegistryItem item = (ChickensRegistryItem)Iterables.get(ChickensRegistry.getItems(), (int)((int)(System.currentTimeMillis() / 1000L % (long)ChickensRegistry.getItems().size())));
            s = item.registryName.toString();
        }
        if (s.isEmpty()) {
            return;
        }
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(new ResourceLocation(s));
        if (entityType == null) {
            return;
        }
        Entity entity = entityType.create((Level)mc.level);
        if (entity == null) {
            return;
        }
        EntityChickensChicken chicken = (EntityChickensChicken)entity;
        if (chicken == null) {
            return;
        }
        chicken.yHeadRot = 0.0f;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.0f, 0.5f);
        if (transformType == ItemDisplayContext.GUI) {
            Lighting.setupForFlatItems();
        }
        if (mc.getEntityRenderDispatcher() != null) {
            EntityRenderDispatcher entityRenderDispatcher = mc.getEntityRenderDispatcher();
            MultiBufferSource.BufferSource irendertypebuffer$impl = mc.renderBuffers().bufferSource();
            entityRenderDispatcher.getRenderer((Entity)chicken).render((Entity)chicken, 0.0f, 0.0f, poseStack, (MultiBufferSource)irendertypebuffer$impl, combinedLight);
        }
        poseStack.popPose();
    }
}

