/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.client.gui;

import com.mojang.math.Axis;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.blockentities.EggCrackerBlockEntity;
import net.creeperhost.chickens.client.ChickenGuiTextures;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.EggCrackerMenu;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiContainer;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiEnergyBar;
import net.creeperhost.polylib.client.modulargui.elements.GuiFluidTank;
import net.creeperhost.polylib.client.modulargui.elements.GuiManipulable;
import net.creeperhost.polylib.client.modulargui.elements.GuiProgressIcon;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlots;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Direction;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class EggCrackerGui
extends ContainerGuiProvider<EggCrackerMenu> {
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT = 185;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), ChickenGuiTextures.get("egg_cracker"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<EggCrackerMenu> screenAccess) {
        gui.initStandardGui(176, 185);
        EggCrackerMenu menu = (EggCrackerMenu)screenAccess.getMenu();
        EggCrackerBlockEntity tile = (EggCrackerBlockEntity)menu.tile;
        gui.setGuiTitle(tile.getDisplayName());
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).setTextColour(0x404040).setShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        Assembly playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        Constraints.placeInside((ConstrainedGeometry)playInv.container, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiText invTitle = (GuiText)((GuiText)new GuiText((GuiParent)playInv.container, (Component)Component.translatable((String)"container.inventory")).setAlignment(Align.LEFT).setTextColour(0x404040).setShadow(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.WIDTH)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        Constraints.placeInside((ConstrainedGeometry)invTitle, (ConstrainedGeometry)playInv.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)-10.0);
        GuiSlots bucketSlot = (GuiSlots)((GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.fluidSlot).setEmptyIcon(PolyTextures.get((String)"slots/bucket")).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.cracker.fluid_slot")})).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)invTitle.get(GeoParam.TOP), (double)-2.0));
        Assembly tank = GuiFluidTank.simpleTank((GuiParent)root);
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)tank.container).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)18.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)bucketSlot.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)bucketSlot.get(GeoParam.TOP), (double)-2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)6.0));
        ((GuiFluidTank)tank.primary).setCapacity(() -> ((PolyTank)tile.tank).getCapacity()).setFluidStack(() -> menu.tank.get());
        GuiSlots outputSlots = new GuiSlots((GuiParent)root, screenAccess, menu.output, 6);
        Constraints.placeOutside((ConstrainedGeometry)outputSlots, (ConstrainedGeometry)playInv.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-12.0);
        GuiSlots inputSlot = new GuiSlots((GuiParent)root, screenAccess, menu.input, 1);
        Constraints.placeOutside((ConstrainedGeometry)inputSlot, (ConstrainedGeometry)outputSlots, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-36.0);
        this.reverseEggDropChallenge(root, menu, inputSlot, outputSlots);
        boolean energy = Config.INSTANCE.enableEnergy;
        if (energy) {
            GuiSlots energySlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.energySlot).setEmptyIcon(PolyTextures.get((String)"slots/energy")).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)bucketSlot.get(GeoParam.BOTTOM)));
            Assembly energyBar = GuiEnergyBar.simpleBar((GuiParent)root);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)energyBar.container).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)((GuiRectangle)tank.container).get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.TOP), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.LEFT), (double)0.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.RIGHT), (double)0.0));
            ((GuiEnergyBar)energyBar.primary).setCapacity(() -> ((PolyEnergyStorage)tile.energy).getMaxEnergyStored()).setEnergy(() -> menu.energy.get());
        }
        GuiButton rsButton = GuiButton.redstoneButton((GuiParent)root, (RedstoneActivatedBlock)tile);
        Constraints.placeOutside((ConstrainedGeometry)rsButton, (ConstrainedGeometry)tank.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)-2.0, (double)12.0);
    }

    private void reverseEggDropChallenge(GuiElement<?> root, EggCrackerMenu menu, GuiSlots inputSlot, GuiSlots outputSlots) {
        GuiProgressIcon arrow = new GuiProgressIcon(root).setBackground(PolyTextures.get((String)"widgets/progress_arrow_empty")).setAnimated(PolyTextures.get((String)"widgets/progress_arrow_full")).setDirection(Direction.DOWN).setProgress(() -> (double)((Integer)menu.progress.get()).intValue() / (double)Config.INSTANCE.crackerProcessTime);
        Constraints.size((ConstrainedGeometry)arrow, (double)16.0, (double)22.0);
        Constraints.placeOutside((ConstrainedGeometry)arrow, (ConstrainedGeometry)inputSlot, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)5.0);
        EggDropTrapDoor trapDoor = new EggDropTrapDoor((GuiParent<?>)root, menu);
        Constraints.bind((ConstrainedGeometry)trapDoor, (ConstrainedGeometry)inputSlot);
        trapDoor.floorPlate = new GuiRectangle(root).fill(-16777216);
        Constraints.size(trapDoor.floorPlate, (double)32.0, (double)2.0);
        Constraints.placeOutside(trapDoor.floorPlate, (ConstrainedGeometry)outputSlots, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)-1.0);
    }

    private static class EggDropTrapDoor
    extends GuiElement<EggDropTrapDoor>
    implements BackgroundRender {
        private final EggCrackerMenu menu;
        private GuiElement<?> floorPlate;

        public EggDropTrapDoor(@NotNull GuiParent<?> parent, EggCrackerMenu menu) {
            super(parent);
            this.menu = menu;
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            ItemChickenEgg eggItem;
            float progress;
            ItemStack stack;
            block9: {
                block8: {
                    Item item;
                    stack = this.menu.input.getSlot(0).getItem();
                    progress = Math.min((float)((Integer)this.menu.progress.get()).intValue() + partialTicks, (float)Config.INSTANCE.crackerProcessTime);
                    if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemChickenEgg)) break block8;
                    eggItem = (ItemChickenEgg)item;
                    if (progress != 0.0f) break block9;
                }
                return;
            }
            ChickensRegistryItem type = eggItem.getType(stack);
            if (type == null) {
                return;
            }
            int colour = type.getBgColor();
            float animation = progress / (float)Config.INSTANCE.crackerProcessTime;
            float maxAnimLen = 30.0f;
            if ((float)Config.INSTANCE.crackerProcessTime > maxAnimLen) {
                float remain = (float)Config.INSTANCE.crackerProcessTime - progress;
                float f = animation = remain < maxAnimLen ? 1.0f - remain / maxAnimLen : 0.0f;
            }
            if (animation <= 0.0f) {
                return;
            }
            render.fill(this.xMin() + 1.0, this.yMax() - 1.0, this.xMax() - 1.0, this.yMax(), -7631989);
            float doorAnim = (float)Math.sin(Math.min((double)animation * 1.1, 1.0) * Math.PI);
            render.pose().pushPose();
            render.pose().translate(this.xMin() + 1.5, this.yMax() - 0.5, 0.0);
            render.pose().mulPose(Axis.ZP.rotationDegrees(doorAnim * 125.0f));
            render.rect(-0.5, -0.5, 8.0, 1.0, -1);
            render.pose().popPose();
            render.pose().pushPose();
            render.pose().translate(this.xMax() - 1.5, this.yMax() - 0.5, 0.0);
            render.pose().mulPose(Axis.ZP.rotationDegrees(180.0f - doorAnim * 125.0f));
            render.rect(-0.5, -0.5, 8.0, 1.0, -1);
            render.pose().popPose();
            Material eggMat = ChickenGuiTextures.get("elements/egg");
            Material eggCrackedMat = ChickenGuiTextures.get("elements/egg_cracked");
            float dropAnim = Math.min(1.0f, (1.0f - (float)Math.cos((double)animation * Math.PI * 0.5)) * 2.0f);
            float sinkAnim = Math.max(0.0f, animation - 0.5f) * 2.0f;
            double yTravel = (this.floorPlate.yMin() - this.yCenter() - 4.0) * (double)dropAnim;
            render.pose().pushPose();
            if (dropAnim < 1.0f) {
                render.pose().translate(this.xCenter(), this.yCenter() + yTravel, 0.0);
                render.pose().mulPose(Axis.ZP.rotationDegrees(dropAnim * 180.0f));
                render.texRect(eggMat, -8.0, -8.0, 16.0, 16.0, colour | 0xFF000000);
            } else {
                render.pose().translate(0.0, (double)sinkAnim * 2.0, 0.0);
                render.texRect(eggCrackedMat, this.xCenter() - 8.0, this.floorPlate.yMin() - 16.0, 16.0, 16.0, colour | (int)((1.0f - sinkAnim) * 255.0f) << 24);
            }
            render.pose().popPose();
        }
    }

    public static class Screen
    extends ModularGuiContainer<EggCrackerMenu> {
        public Screen(EggCrackerMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new EggCrackerGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

