/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.client.gui;

import dev.architectury.fluid.FluidStack;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.chickens.blockentities.IncubatorBlockEntity;
import net.creeperhost.chickens.client.ChickenGuiTextures;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.IncubatorMenu;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiContainer;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiEnergyBar;
import net.creeperhost.polylib.client.modulargui.elements.GuiFluidTank;
import net.creeperhost.polylib.client.modulargui.elements.GuiManipulable;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlots;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextList;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.data.serializable.AbstractDataStore;
import net.creeperhost.polylib.helpers.MathUtil;
import net.creeperhost.polylib.inventory.fluid.PolyTank;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class IncubatorGui
extends ContainerGuiProvider<IncubatorMenu> {
    public static final int GUI_WIDTH = 180;
    public static final int GUI_HEIGHT = 176;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), ChickenGuiTextures.get("incubator"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<IncubatorMenu> screenAccess) {
        gui.initStandardGui(180, 176);
        IncubatorMenu menu = (IncubatorMenu)screenAccess.getMenu();
        IncubatorBlockEntity tile = (IncubatorBlockEntity)menu.tile;
        gui.setGuiTitle(tile.getDisplayName());
        GuiElement root = gui.getRoot();
        Assembly playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        Constraints.placeInside((ConstrainedGeometry)playInv.container, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiText invTitle = (GuiText)((GuiText)new GuiText((GuiParent)playInv.container, (Component)Component.translatable((String)"container.inventory")).setAlignment(Align.LEFT).setTextColour(0x404040).setShadow(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.WIDTH)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        Constraints.placeInside((ConstrainedGeometry)invTitle, (ConstrainedGeometry)playInv.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)-10.0);
        boolean energy = Config.INSTANCE.enableEnergy;
        GuiRectangle eggsBorder = GuiRectangle.invertedSlot((GuiParent)root);
        GuiSlots eggSlots = new GuiSlots((GuiParent)root, screenAccess, menu.eggSlots, 3);
        Constraints.placeInside((ConstrainedGeometry)eggSlots, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)(energy ? 4.0 : 0.0), (double)26.0);
        Constraints.bind((ConstrainedGeometry)eggsBorder, (ConstrainedGeometry)eggSlots, (double)-1.0);
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).setTextColour(0x404040).setShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.RIGHT)));
        GuiSlots waterSlot = (GuiSlots)((GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.waterSlot).setEmptyIcon(PolyTextures.get((String)"slots/bucket")).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.incubator.water_slot")})).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.RIGHT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.BOTTOM)));
        Assembly tank = GuiFluidTank.simpleTank((GuiParent)root);
        ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)tank.container).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)18.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)waterSlot.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)waterSlot.get(GeoParam.TOP), (double)-2.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)6.0));
        ((GuiFluidTank)tank.primary).setCapacity(() -> ((PolyTank)tile.tank).getCapacity()).setFluidStack(() -> menu.tank.get());
        GuiElement<?> thermometer = this.createThermometer(root, menu);
        Constraints.placeInside(thermometer, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)(energy ? 29.0 : 7.0), (double)8.0);
        GuiElement<?> hygrometer = this.createHygrometer(root, menu);
        Constraints.placeOutside(hygrometer, thermometer, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)(energy ? 2.0 : 10.0), (double)0.0);
        if (energy) {
            GuiSlots energySlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.energySlot).setEmptyIcon(PolyTextures.get((String)"slots/energy")).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.BOTTOM)));
            Assembly energyBar = GuiEnergyBar.simpleBar((GuiParent)root);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)energyBar.container).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)thermometer.get(GeoParam.TOP), (double)-3.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.TOP), (double)-2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.LEFT), (double)0.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.RIGHT), (double)0.0));
            ((GuiEnergyBar)energyBar.primary).setCapacity(() -> ((PolyEnergyStorage)tile.energy).getMaxEnergyStored()).setEnergy(() -> menu.energy.get());
        }
        GuiTexture lightOff = new GuiTexture((GuiParent)root, ChickenGuiTextures.get("elements/incubator_light"));
        Constraints.size((ConstrainedGeometry)lightOff, (double)64.0, (double)16.0);
        Constraints.placeOutside((ConstrainedGeometry)lightOff, (ConstrainedGeometry)eggsBorder, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)4.0);
        GuiTexture lightOn = new GuiTexture((GuiParent)root, ChickenGuiTextures.get("elements/incubator_light_on"));
        lightOn.setColour(() -> 0xFFFFFF | (Integer)menu.heatSetting.get() * 17 << 24);
        Constraints.size((ConstrainedGeometry)lightOn, (double)64.0, (double)16.0);
        Constraints.placeOutside((ConstrainedGeometry)lightOn, (ConstrainedGeometry)eggsBorder, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)4.0);
        GuiTextList heatLabel = ((GuiTextList)((GuiTextList)new GuiTextList((GuiParent)root).setTextSupplier(() -> List.of(Component.translatable((String)"gui.chickens.incubator.heat"), Component.literal((String)String.valueOf(menu.heatSetting.get())))).setTextColour(0x404040).setShadow(false).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)eggsBorder.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)((GuiRectangle)tank.container).get(GeoParam.LEFT), (double)-2.0))).autoHeight();
        heatLabel.constrain(GeoParam.TOP, (Constraint)Constraint.midPoint((GeoRef)eggsBorder.get(GeoParam.TOP), (GeoRef)eggsBorder.get(GeoParam.BOTTOM), (double)(heatLabel.ySize() / -2.0)));
        GuiButton incButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.vanillaAnimated((GuiParent)root, (Component)Component.literal((String)"\u2191 \u2191")).setDisabled(() -> (Integer)menu.heatSetting.get() >= 15).onPress(() -> tile.sendDataValueToServer((AbstractDataStore)tile.heatSetting, (Integer)menu.heatSetting.get() + 1)).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.incubator.increase_heat")})).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.TOP)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)eggsBorder.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)((GuiRectangle)tank.container).get(GeoParam.LEFT), (double)-5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton decButton = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)GuiButton.vanillaAnimated((GuiParent)root, (Component)Component.literal((String)"\u2193 \u2193")).setDisabled(() -> (Integer)menu.heatSetting.get() <= 0).onPress(() -> tile.sendDataValueToServer((AbstractDataStore)tile.heatSetting, (Integer)menu.heatSetting.get() - 1)).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.incubator.decrease_heat")})).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)eggsBorder.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)eggsBorder.get(GeoParam.RIGHT), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)((GuiRectangle)tank.container).get(GeoParam.LEFT), (double)-5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton rsButton = GuiButton.redstoneButton((GuiParent)root, (RedstoneActivatedBlock)tile);
        Constraints.placeOutside((ConstrainedGeometry)rsButton, (ConstrainedGeometry)tank.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)-2.0, (double)12.0);
    }

    public GuiElement<?> createThermometer(GuiElement<?> root, IncubatorMenu menu) {
        GuiRectangle slot = GuiRectangle.invertedSlot(root);
        GuiRectangle slot2 = GuiRectangle.vanillaSlot(root);
        Constraints.bind((ConstrainedGeometry)slot2, (ConstrainedGeometry)slot, (double)1.0);
        GuiTexture texture = new GuiTexture(root, ChickenGuiTextures.get("elements/thermometer"));
        Constraints.size((ConstrainedGeometry)texture, (double)16.0, (double)70.0);
        Constraints.bind((ConstrainedGeometry)slot, (ConstrainedGeometry)texture, (double)-3.0, (double)0.0, (double)-3.0, (double)0.0);
        texture.setTooltipDelay(0);
        texture.setTooltip(() -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)"gui.chickens.incubator.temperature.info"));
            list.add(Component.translatable((String)"gui.chickens.incubator.temperature.temp", (Object[])new Object[]{menu.temperature.get()}).withStyle(ChatFormatting.GOLD));
            if ((Integer)menu.temperature.get() > IncubatorBlockEntity.TEMP_MAX) {
                list.add(Component.translatable((String)"gui.chickens.incubator.temperature.hot").withStyle(ChatFormatting.RED));
            } else if ((Integer)menu.temperature.get() < IncubatorBlockEntity.TEMP_MIN) {
                list.add(Component.translatable((String)"gui.chickens.incubator.temperature.cold").withStyle(ChatFormatting.BLUE));
            }
            return list;
        });
        GuiRectangle zone = new GuiRectangle((GuiParent)texture){

            public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                render.fill(this.xMin(), this.yMin(), this.xMin() + 1.0, this.yMax(), -16711936);
                render.gradientFillV(this.xMin(), this.yMax(), this.xMin() + 1.0, this.yMax() + 6.0, -16776961, 0);
                render.gradientFillV(this.xMin(), this.yMin() - 6.0, this.xMin() + 1.0, this.yMin(), 0, -65536);
                render.fill(this.xMax() - 1.0, this.yMin(), this.xMax(), this.yMax(), -16711936);
                render.gradientFillV(this.xMax() - 1.0, this.yMax(), this.xMax(), this.yMax() + 6.0, -16776961, 0);
                render.gradientFillV(this.xMax() - 1.0, this.yMin() - 6.0, this.xMax(), this.yMin(), 0, -65536);
            }
        };
        zone.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.LEFT), (double)6.0));
        zone.constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        zone.constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), (double)(-8 - IncubatorBlockEntity.TEMP_MIN)));
        zone.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), (double)(-8 - IncubatorBlockEntity.TEMP_MAX - 1)));
        GuiRectangle bar = (GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)texture).fill(-65536).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.LEFT), (double)7.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), (double)-9.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.dynamic(() -> MathUtil.clamp((int)((Integer)menu.temperature.get()), (int)0, (int)60)));
        return texture;
    }

    public GuiElement<?> createHygrometer(GuiElement<?> root, IncubatorMenu menu) {
        GuiRectangle slot = GuiRectangle.invertedSlot(root);
        GuiRectangle slot2 = GuiRectangle.vanillaSlot(root);
        Constraints.bind((ConstrainedGeometry)slot2, (ConstrainedGeometry)slot, (double)1.0);
        GuiTexture texture = new GuiTexture(root, ChickenGuiTextures.get("elements/hygrometer"));
        Constraints.size((ConstrainedGeometry)texture, (double)16.0, (double)70.0);
        Constraints.bind((ConstrainedGeometry)slot, (ConstrainedGeometry)texture, (double)-3.0, (double)0.0, (double)-3.0, (double)0.0);
        texture.setTooltipDelay(0);
        texture.setTooltip(() -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)"gui.chickens.incubator.hygrometer.info"));
            list.add(Component.translatable((String)"gui.chickens.incubator.hygrometer.value", (Object[])new Object[]{String.format("%.1f", menu.humidity.get())}).withStyle(ChatFormatting.GOLD));
            if (((Float)menu.humidity.get()).floatValue() < (float)IncubatorBlockEntity.MIN_HUMIDITY && ((FluidStack)menu.tank.get()).isEmpty()) {
                list.add(Component.translatable((String)"gui.chickens.incubator.hygrometer.dry").withStyle(ChatFormatting.RED));
            }
            return list;
        });
        GuiRectangle zone = new GuiRectangle((GuiParent)texture){

            public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
                render.gradientFillV(this.xMin(), this.yMin(), this.xMin() + 1.0, this.yMax(), 0, -16711936);
                render.gradientFillV(this.xMin(), this.yMax(), this.xMin() + 1.0, this.yMax() + 5.0, -16711936, 0x77FF0000);
                render.gradientFillV(this.xMin(), this.yMax() + 5.0, this.xMin() + 1.0, this.yMax() + 10.0, 0x77FF0000, 0xFF0000);
                render.gradientFillV(this.xMax() - 1.0, this.yMin(), this.xMax(), this.yMax(), 0, -16711936);
                render.gradientFillV(this.xMax() - 1.0, this.yMax(), this.xMax(), this.yMax() + 5.0, -16711936, 0x77FF0000);
                render.gradientFillV(this.xMax() - 1.0, this.yMax() + 5.0, this.xMax(), this.yMax() + 10.0, 0x77FF0000, 0xFF0000);
            }
        };
        zone.constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.LEFT), (double)6.0));
        zone.constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)4.0));
        zone.constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), (double)(-2 - IncubatorBlockEntity.MIN_HUMIDITY)));
        zone.constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), (double)(-2 - IncubatorBlockEntity.MIN_HUMIDITY - 10)));
        GuiTexture pointer = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)texture, ChickenGuiTextures.get("elements/hygro_pointer")).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.LEFT), (double)4.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)texture.get(GeoParam.BOTTOM), () -> 2.0 - (double)MathUtil.clamp((float)((Float)menu.humidity.get()).floatValue(), (float)0.0f, (float)65.0f)).precise());
        return texture;
    }

    public static class Screen
    extends ModularGuiContainer<IncubatorMenu> {
        public Screen(IncubatorMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new IncubatorGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

