/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.client.gui;

import java.util.Random;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.blockentities.OvoscopeBlockEntity;
import net.creeperhost.chickens.client.ChickenGuiTextures;
import net.creeperhost.chickens.config.Config;
import net.creeperhost.chickens.containers.OvoscopeMenu;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.creeperhost.polylib.blocks.RedstoneActivatedBlock;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.ModularGuiContainer;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiEnergyBar;
import net.creeperhost.polylib.client.modulargui.elements.GuiManipulable;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlots;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.ForegroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerGuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.container.ContainerScreenAccess;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.inventory.power.PolyEnergyStorage;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class OvoscopeGui
extends ContainerGuiProvider<OvoscopeMenu> {
    public static final int GUI_WIDTH = 176;
    public static final int GUI_HEIGHT = 160;

    public GuiElement<?> createRootElement(ModularGui gui) {
        GuiManipulable root = new GuiManipulable((GuiParent)gui).addMoveHandle(3).enableCursors(true);
        GuiTexture bg = new GuiTexture((GuiParent)root.getContentElement(), ChickenGuiTextures.get("ovoscope"));
        Constraints.bind((ConstrainedGeometry)bg, (ConstrainedGeometry)root.getContentElement());
        return root;
    }

    public void buildGui(ModularGui gui, ContainerScreenAccess<OvoscopeMenu> screenAccess) {
        gui.initStandardGui(176, 160);
        OvoscopeMenu menu = (OvoscopeMenu)screenAccess.getMenu();
        OvoscopeBlockEntity tile = (OvoscopeBlockEntity)menu.tile;
        gui.setGuiTitle(tile.getDisplayName());
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).setTextColour(0x404040).setShadow(false).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)4.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        Assembly playInv = GuiSlots.player((GuiParent)root, screenAccess, (SlotGroup)menu.main, (SlotGroup)menu.hotBar);
        Constraints.placeInside((ConstrainedGeometry)playInv.container, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.BOTTOM_CENTER, (double)0.0, (double)-7.0);
        GuiText invTitle = (GuiText)((GuiText)new GuiText((GuiParent)playInv.container, (Component)Component.translatable((String)"container.inventory")).setAlignment(Align.LEFT).setTextColour(0x404040).setShadow(false).constrain(GeoParam.WIDTH, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.WIDTH)))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
        Constraints.placeInside((ConstrainedGeometry)invTitle, (ConstrainedGeometry)playInv.container, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_LEFT, (double)0.0, (double)-10.0);
        GuiTexture slotTex = new GuiTexture((GuiParent)root, () -> ChickenGuiTextures.get("elements/ovoscope_slot" + ((Boolean)menu.scanning.get() != false ? "_active" : "")));
        Constraints.size((ConstrainedGeometry)slotTex, (double)22.0, (double)22.0);
        Constraints.placeInside((ConstrainedGeometry)slotTex, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_CENTER, (double)0.0, (double)28.0);
        GuiSlots inputSlot = GuiSlots.singleSlot((GuiParent)slotTex, screenAccess, (SlotGroup)menu.input).setSlotTexture(integer -> null);
        Constraints.center((ConstrainedGeometry)inputSlot, (ConstrainedGeometry)slotTex);
        Constraints.bind((ConstrainedGeometry)new Scanner((GuiParent<?>)root, menu), (ConstrainedGeometry)slotTex, (double)1.0);
        GuiTexture viableTex = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, ChickenGuiTextures.get("elements/viable_arrow")).setTooltipDelay(0)).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.ovoscope.viable")});
        Constraints.size((ConstrainedGeometry)viableTex, (double)24.0, (double)16.0);
        Constraints.placeOutside((ConstrainedGeometry)viableTex, (ConstrainedGeometry)inputSlot, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)4.0, (double)0.0);
        GuiSlots viableSlot = GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.viable);
        Constraints.placeOutside((ConstrainedGeometry)viableSlot, (ConstrainedGeometry)viableTex, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_RIGHT, (double)2.0, (double)0.0);
        GuiTexture nonViableTex = (GuiTexture)((GuiTexture)new GuiTexture((GuiParent)root, ChickenGuiTextures.get("elements/non_viable_arrow")).setTooltipDelay(0)).setTooltip(new Component[]{Component.translatable((String)"gui.chickens.ovoscope.non_viable")});
        Constraints.size((ConstrainedGeometry)nonViableTex, (double)24.0, (double)16.0);
        Constraints.placeOutside((ConstrainedGeometry)nonViableTex, (ConstrainedGeometry)inputSlot, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)-4.0, (double)0.0);
        GuiSlots nonViableSlot = GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.nonViable);
        Constraints.placeOutside((ConstrainedGeometry)nonViableSlot, (ConstrainedGeometry)nonViableTex, (Constraints.LayoutPos)Constraints.LayoutPos.MIDDLE_LEFT, (double)-2.0, (double)0.0);
        if (Config.INSTANCE.enableEnergy) {
            GuiSlots energySlot = (GuiSlots)((GuiSlots)GuiSlots.singleSlot((GuiParent)root, screenAccess, (SlotGroup)menu.energySlot).setEmptyIcon(PolyTextures.get((String)"slots/energy")).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)playInv.container.get(GeoParam.LEFT)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)invTitle.get(GeoParam.TOP), (double)-2.0));
            Assembly energyBar = GuiEnergyBar.simpleBar((GuiParent)root);
            ((GuiRectangle)((GuiRectangle)((GuiRectangle)((GuiRectangle)energyBar.container).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.TOP), (double)-1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.LEFT), (double)0.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)energySlot.get(GeoParam.RIGHT), (double)0.0));
            ((GuiEnergyBar)energyBar.primary).setCapacity(() -> ((PolyEnergyStorage)tile.energy).getMaxEnergyStored()).setEnergy(() -> menu.energy.get());
        }
        GuiButton rsButton = GuiButton.redstoneButton((GuiParent)root, (RedstoneActivatedBlock)tile);
        Constraints.placeInside((ConstrainedGeometry)rsButton, (ConstrainedGeometry)root, (Constraints.LayoutPos)Constraints.LayoutPos.TOP_RIGHT, (double)-4.0, (double)4.0);
    }

    public static class Scanner
    extends GuiElement<Scanner>
    implements ForegroundRender {
        private static final Random randy = new Random();
        private final OvoscopeMenu menu;

        public Scanner(@NotNull GuiParent<?> parent, OvoscopeMenu menu) {
            super(parent);
            this.menu = menu;
        }

        public void renderInFront(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            ItemChickenEgg eggItem;
            ItemStack stack;
            block5: {
                block4: {
                    Item item;
                    stack = this.menu.input.getSlot(0).getItem();
                    if (stack.isEmpty() || !((item = stack.getItem()) instanceof ItemChickenEgg)) break block4;
                    eggItem = (ItemChickenEgg)item;
                    if (((Boolean)this.menu.scanning.get()).booleanValue()) break block5;
                }
                return;
            }
            ChickensRegistryItem type = eggItem.getType(stack);
            if (type == null) {
                return;
            }
            int colour = type.getBgColor();
            randy.setSeed(((Byte)this.menu.scanCount.get()).byteValue());
            int pIndex = randy.nextInt(1, 4);
            boolean viable = eggItem.isViable(stack);
            float progress = (float)((Integer)this.menu.progress.get()).intValue() / (float)Config.INSTANCE.ovoscopeProcessTime;
            float barWidth = (Math.min(1.0f, progress * 8.0f) - Math.max(0.0f, (progress - 0.875f) * 8.0f)) * 9.0f;
            float barPos = Math.min(Math.max(progress - 0.125f, 0.0f), 0.75f) / 0.75f;
            barPos = (float)Math.sin((double)barPos * Math.PI) * 16.0f;
            render.pose().pushPose();
            render.pose().translate(0.0f, 0.0f, 300.0f);
            Material egg = ChickenGuiTextures.get("elements/egg");
            Material backing = ChickenGuiTextures.get("scope_patterns/backing");
            Material pattern = ChickenGuiTextures.get("scope_patterns/" + (viable ? "viable_" : "non_viable_") + pIndex);
            render.texRect(backing, this.xCenter() - 8.0, this.yCenter() - 8.0, 16.0, 16.0);
            render.texRect(pattern, this.xCenter() - 8.0, this.yCenter() - 8.0, 16.0, 16.0, -65536);
            render.texRect(egg, this.xCenter() - 8.0, this.yCenter() - 8.0, 16.0, 16.0, 0xBB000000 | colour);
            render.fill(this.xCenter() - (double)barWidth, this.yMin() + 1.0 + (double)barPos, this.xCenter() + (double)barWidth, this.yMin() + 2.0 + (double)barPos, -65536);
            render.pose().popPose();
        }
    }

    public static class Screen
    extends ModularGuiContainer<OvoscopeMenu> {
        public Screen(OvoscopeMenu menu, Inventory inv, Component title) {
            super((AbstractContainerMenu)menu, inv, (ContainerGuiProvider)new OvoscopeGui());
            this.getModularGui().setGuiTitle(title);
        }
    }
}

