/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jade;

import net.creeperhost.chickens.entity.EntityChickensChicken;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation ENTITY_DATA_ID = new ResourceLocation("chickens", "entity_data");

    public void register(IWailaCommonRegistration registration) {
        registration.registerEntityDataProvider((IServerDataProvider)new IServerDataProvider<EntityAccessor>(){

            public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
                Entity entity = accessor.getEntity();
                if (entity instanceof EntityChickensChicken) {
                    EntityChickensChicken entityChickensChicken = (EntityChickensChicken)entity;
                    tag.putInt("lifespan", entityChickensChicken.getLifeSpan());
                }
            }

            public ResourceLocation getUid() {
                return ENTITY_DATA_ID;
            }
        }, EntityChickensChicken.class);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerEntityComponent(new IEntityComponentProvider(){

            public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig iPluginConfig) {
                tooltip.add((Component)Component.literal((String)("Lifespan " + accessor.getServerData().get("lifespan"))));
            }

            public ResourceLocation getUid() {
                return ENTITY_DATA_ID;
            }
        }, EntityChickensChicken.class);
    }
}

