/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.creeperhost.chickens.compat.jei.ChickensRecipeTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ChickenDropsCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = Component.translatable((String)"gui.drops");
    IGuiHelper guiHelper;

    public ChickenDropsCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return ChickensRecipeTypes.DROPS;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("chickens", "textures/gui/drops.png"), 0, 0, 82, 54).addPadding(0, 20, 0, 0).build();
    }

    @NotNull
    public IDrawable getIcon() {
        return this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/drops_icon.png"), 0, 0, 16, 16);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 15).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.input}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 15).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.output}));
    }

    public static class Recipe {
        private final ItemStack input;
        private final ItemStack output;

        public Recipe(ItemStack input, ItemStack output) {
            this.input = input;
            this.output = output;
        }
    }
}

