/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.Constants;
import net.creeperhost.chickens.compat.jei.ChickensRecipeTypes;
import net.creeperhost.chickens.init.ModBlocks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ChickenIncubatorCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = Component.translatable((String)"gui.chicken.incubator");
    IGuiHelper guiHelper;

    public ChickenIncubatorCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public RecipeType<Recipe> getRecipeType() {
        return ChickensRecipeTypes.INCUBATOR;
    }

    public Component getTitle() {
        return TITLE;
    }

    public IDrawable getBackground() {
        return this.guiHelper.createDrawable(Constants.RECIPE_GUI_VANILLA, 0, 222, 82, 34);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()));
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 7).addItemStack(recipe.getEgg());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 7).addItemStack(recipe.getChicken());
    }

    public static class Recipe {
        ItemStack egg;
        ItemStack chicken;

        public Recipe(ItemStack egg, ItemStack chicken) {
            this.egg = egg;
            this.chicken = chicken;
        }

        public ItemStack getEgg() {
            return this.egg;
        }

        public ItemStack getChicken() {
            return this.chicken;
        }
    }
}

