/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.creeperhost.chickens.compat.jei.ChickensRecipeTypes;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ChickenLayingCategory
implements IRecipeCategory<Recipe> {
    public static final Component TITLE = Component.translatable((String)"gui.laying");
    IGuiHelper guiHelper;

    public ChickenLayingCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    @NotNull
    public RecipeType<Recipe> getRecipeType() {
        return ChickensRecipeTypes.LAYING;
    }

    @NotNull
    public Component getTitle() {
        return TITLE;
    }

    @NotNull
    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("chickens", "textures/gui/laying.png"), 0, 0, 82, 54).addPadding(0, 20, 0, 0).build();
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/laying_icon.png"), 0, 0, 16, 16);
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        IDrawableStatic arrowDrawable = this.guiHelper.createDrawable(new ResourceLocation("chickens", "textures/gui/breeding.png"), 82, 0, 7, 7);
        this.guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, @NotNull Recipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 15).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.chicken}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 15).addIngredients(Ingredient.of((ItemStack[])new ItemStack[]{recipe.egg}));
    }

    public static class Recipe {
        private final ItemStack chicken;
        private final ItemStack egg;
        private final int minTime;
        private final int maxTime;

        public Recipe(ItemStack chicken, ItemStack egg, int minTime, int maxTime) {
            this.chicken = chicken;
            this.egg = egg;
            this.minTime = minTime;
            this.maxTime = maxTime;
        }
    }
}

