/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.creeperhost.chickens.api.ChickenAPI;
import net.creeperhost.chickens.api.ChickensRegistry;
import net.creeperhost.chickens.api.ChickensRegistryItem;
import net.creeperhost.chickens.compat.jei.ChickenBreedingCategory;
import net.creeperhost.chickens.compat.jei.ChickenDropsCategory;
import net.creeperhost.chickens.compat.jei.ChickenIncubatorCategory;
import net.creeperhost.chickens.compat.jei.ChickenInteractionCategory;
import net.creeperhost.chickens.compat.jei.ChickenLayingCategory;
import net.creeperhost.chickens.compat.jei.ChickenSubtypeInterpreter;
import net.creeperhost.chickens.compat.jei.ChickensRecipeTypes;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.item.ItemChicken;
import net.creeperhost.chickens.item.ItemChickenEgg;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class ChickensJeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("chickens", "jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenBreedingCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenDropsCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenLayingCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenIncubatorCategory(jeiHelpers.getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChickenInteractionCategory(jeiHelpers.getGuiHelper())});
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.BREEDER.get()), new RecipeType[]{ChickensRecipeTypes.BREEDING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.INCUBATOR.get()), new RecipeType[]{ChickensRecipeTypes.INCUBATOR});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)ModItems.CHICKEN_ITEM.get(), (IIngredientSubtypeInterpreter)ChickenSubtypeInterpreter.INSTANCE);
        registration.useNbtForSubtypes(new Item[]{(Item)ModItems.CHICKEN_EGG.get()});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        registry.addRecipes(ChickensRecipeTypes.BREEDING, this.getBreedingRecipes());
        registry.addRecipes(ChickensRecipeTypes.LAYING, this.getLayingRecipes());
        registry.addRecipes(ChickensRecipeTypes.DROPS, this.getDropRecipes());
        registry.addRecipes(ChickensRecipeTypes.INCUBATOR, this.getIncubatorRecipes());
        registry.addRecipes(ChickensRecipeTypes.INTERACTION, ChickenAPI.TRANSFORMATION_RECIPES);
    }

    private List<ChickenIncubatorCategory.Recipe> getIncubatorRecipes() {
        ArrayList<ChickenIncubatorCategory.Recipe> recipes = new ArrayList<ChickenIncubatorCategory.Recipe>();
        for (ChickensRegistryItem chickensRegistryItem : ChickensRegistry.getItems()) {
            ItemStack chicken;
            ItemStack egg = ItemChickenEgg.of(chickensRegistryItem);
            if (egg.isEmpty() || (chicken = ItemChicken.of(chickensRegistryItem)).isEmpty()) continue;
            recipes.add(new ChickenIncubatorCategory.Recipe(egg, chicken));
        }
        return recipes;
    }

    private List<ChickenLayingCategory.Recipe> getLayingRecipes() {
        ArrayList<ChickenLayingCategory.Recipe> result = new ArrayList<ChickenLayingCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ItemStack itemstack = ItemChicken.of(chicken);
            result.add(new ChickenLayingCategory.Recipe(itemstack, chicken.createLayItem(), chicken.getMinLayTime(), chicken.getMaxLayTime()));
        }
        return result;
    }

    private List<ChickenDropsCategory.Recipe> getDropRecipes() {
        ArrayList<ChickenDropsCategory.Recipe> result = new ArrayList<ChickenDropsCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            ItemStack itemstack = ItemChicken.of(chicken);
            result.add(new ChickenDropsCategory.Recipe(itemstack, chicken.createLayItem()));
        }
        return result;
    }

    private List<ChickenBreedingCategory.Recipe> getBreedingRecipes() {
        ArrayList<ChickenBreedingCategory.Recipe> result = new ArrayList<ChickenBreedingCategory.Recipe>();
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (!chicken.isBreedable()) continue;
            ItemStack egg = ItemChickenEgg.of(chicken);
            if (chicken.getParent1() == null) continue;
            ItemStack parent1 = ItemChicken.of(chicken.getParent1());
            if (chicken.getParent2() == null) continue;
            ItemStack parent2 = ItemChicken.of(chicken.getParent2());
            result.add(new ChickenBreedingCategory.Recipe(parent1, parent2, egg, ChickensRegistry.getChildChance(chicken)));
        }
        return result;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

